"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _list_item = require("./list_item");
var _and_or_badge = require("../and_or_badge");
var _logic_buttons = require("./logic_buttons");
var _reducer = require("./reducer");
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyInvisibleAndBadge = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  visibility: hidden;
`;
const MyAndBadge = (0, _styledComponents.default)(_and_or_badge.AndOrBadge)`
  & > .euiFlexItem {
    margin: 0;
  }
`;
const MyButtonsContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin: 16px 0;
`;
const initialState = {
  andLogicIncluded: false,
  entries: [],
  entriesToDelete: []
};
const ThreatMatchComponent = ({
  listItems,
  indexPatterns,
  threatIndexPatterns,
  onChange
}) => {
  const [{
    entries,
    entriesToDelete,
    andLogicIncluded
  }, dispatch] = (0, _react.useReducer)((0, _reducer.reducer)(), {
    ...initialState
  });
  const setUpdateEntries = (0, _react.useCallback)(items => {
    dispatch({
      type: 'setEntries',
      entries: items
    });
  }, [dispatch]);
  const setDefaultEntries = (0, _react.useCallback)(item => {
    dispatch({
      type: 'setDefault',
      initialState,
      lastEntry: item
    });
  }, [dispatch]);
  const handleEntryItemChange = (0, _react.useCallback)((item, index) => {
    const updatedEntries = [...entries.slice(0, index), {
      ...item
    }, ...entries.slice(index + 1)];
    setUpdateEntries(updatedEntries);
  }, [setUpdateEntries, entries]);
  const handleDeleteEntryItem = (0, _react.useCallback)((item, itemIndex) => {
    if (item.entries.length === 0) {
      const updatedEntries = [...entries.slice(0, itemIndex), ...entries.slice(itemIndex + 1)];
      // if it's the only item left, don't delete it just add a default entry to it
      if (updatedEntries.length === 0) {
        setDefaultEntries(item);
      } else {
        setUpdateEntries([...entries.slice(0, itemIndex), ...entries.slice(itemIndex + 1)]);
      }
    } else {
      handleEntryItemChange(item, itemIndex);
    }
  }, [handleEntryItemChange, setUpdateEntries, entries, setDefaultEntries]);
  const handleAddNewEntryItemEntry = (0, _react.useCallback)(() => {
    const lastEntry = entries[entries.length - 1];
    const {
      entries: innerEntries
    } = lastEntry;
    const updatedEntry = {
      ...lastEntry,
      entries: [...innerEntries, (0, _helpers.getDefaultEmptyEntry)()]
    };
    setUpdateEntries([...entries.slice(0, entries.length - 1), {
      ...updatedEntry
    }]);
  }, [setUpdateEntries, entries]);
  const handleAddNewEntryItem = (0, _react.useCallback)(() => {
    // There is a case where there are numerous list items, all with
    // empty `entries` array.
    const newItem = (0, _helpers.getNewItem)();
    setUpdateEntries([...entries, {
      ...newItem
    }]);
  }, [setUpdateEntries, entries]);
  const handleAddClick = (0, _react.useCallback)(() => {
    handleAddNewEntryItemEntry();
  }, [handleAddNewEntryItemEntry]);

  // Bubble up changes to parent
  (0, _react.useEffect)(() => {
    onChange({
      entryItems: (0, _helpers.filterItems)(entries),
      entriesToDelete
    });
  }, [onChange, entriesToDelete, entries]);

  // Defaults to never be sans entry, instead
  // always falls back to an empty entry if user deletes all
  (0, _react.useEffect)(() => {
    if (entries.length === 0 || entries.length === 1 && entries[0].entries != null && entries[0].entries.length === 0) {
      handleAddNewEntryItem();
    }
  }, [entries, handleAddNewEntryItem]);
  (0, _react.useEffect)(() => {
    if (listItems.length > 0) {
      setUpdateEntries(listItems);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, entries.map((entryListItem, index) => {
    var _id;
    const key = (_id = entryListItem.id) !== null && _id !== void 0 ? _id : `${index}`;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      key: key
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      direction: "column"
    }, index !== 0 && (andLogicIncluded ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      direction: "row"
    }, /*#__PURE__*/_react.default.createElement(MyInvisibleAndBadge, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(MyAndBadge, {
      includeAntennas: true,
      type: "and"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(MyAndBadge, {
      type: "or"
    })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(MyAndBadge, {
      type: "or"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_list_item.ListItemComponent, {
      key: key,
      listItem: entryListItem,
      indexPattern: indexPatterns,
      threatIndexPatterns: threatIndexPatterns,
      listItemIndex: index,
      andLogicIncluded: andLogicIncluded,
      isOnlyItem: entries.length === 1,
      onDeleteEntryItem: handleDeleteEntryItem,
      onChangeEntryItem: handleEntryItemChange
    }))));
  }), /*#__PURE__*/_react.default.createElement(MyButtonsContainer, {
    "data-test-subj": 'andOrOperatorButtons'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, andLogicIncluded && /*#__PURE__*/_react.default.createElement(MyInvisibleAndBadge, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
    includeAntennas: true,
    type: "and"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_logic_buttons.LogicButtons, {
    isOrDisabled: false,
    isAndDisabled: false,
    onOrClicked: handleAddNewEntryItem,
    onAndClicked: handleAddClick
  })))));
};
exports.ThreatMatchComponent = ThreatMatchComponent;
ThreatMatchComponent.displayName = 'ThreatMatch';