"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetScopedSourcererDataView = void 0;
var _react = require("react");
var _public = require("@kbn/data-views-plugin/public");
var _sourcerer = require("../../containers/sourcerer");
var _kibana = require("../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 *
 * returns the created dataView based on sourcererDataView spec
 * returned from useSourcererDataView
 *
 * */
const useGetScopedSourcererDataView = ({
  sourcererScope
}) => {
  const {
    services: {
      fieldFormats
    }
  } = (0, _kibana.useKibana)();
  const {
    sourcererDataView
  } = (0, _sourcerer.useSourcererDataView)(sourcererScope);
  const dataView = (0, _react.useMemo)(() => {
    if (sourcererDataView) {
      return new _public.DataView({
        spec: sourcererDataView,
        fieldFormats
      });
    } else {
      return undefined;
    }
  }, [sourcererDataView, fieldFormats]);
  return dataView;
};
exports.useGetScopedSourcererDataView = useGetScopedSourcererDataView;