"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecuritySolutionNavigation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactUse = require("react-use");
var _kibana = require("../../../lib/kibana");
var _breadcrumbs = require("../breadcrumbs");
var _security_side_nav = require("../security_side_nav");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const translatedNavTitle = _i18n.i18n.translate('xpack.securitySolution.navigation.mainLabel', {
  defaultMessage: 'Security'
});
const useSecuritySolutionNavigation = onMount => {
  const {
    chrome
  } = (0, _kibana.useKibana)().services;
  const chromeStyle$ = (0, _react.useMemo)(() => chrome.getChromeStyle$(), [chrome]);
  const chromeStyle = (0, _reactUse.useObservable)(chromeStyle$, 'classic');
  (0, _breadcrumbs.useBreadcrumbsNav)();
  if (chromeStyle === 'project') {
    // new shared-ux 'project' navigation enabled, return undefined to disable the 'classic' navigation
    return undefined;
  }
  return {
    canBeCollapsed: true,
    name: translatedNavTitle,
    icon: 'logoSecurity',
    children: /*#__PURE__*/_react.default.createElement(_security_side_nav.SecuritySideNav, {
      onMount: onMount
    }),
    closeFlyoutButtonPosition: 'inside'
  };
};
exports.useSecuritySolutionNavigation = useSecuritySolutionNavigation;