"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeverityColor = exports.getScoreString = exports.ScoreHealth = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getScoreString = score => String(Math.ceil(score));
exports.getScoreString = getScoreString;
const ScoreHealth = exports.ScoreHealth = /*#__PURE__*/_react.default.memo(({
  score
}) => {
  const scoreCeiling = getScoreString(score);
  const color = getSeverityColor(score);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color
  }, scoreCeiling);
});
ScoreHealth.displayName = 'ScoreHealth';

// ಠ_ಠ A hard-fork of the @kbn/ml-anomaly-utils;#getSeverityColor ಠ_ಠ
//
// Returns a severity label (one of critical, major, minor, warning, low or unknown)
// for the supplied normalized anomaly score (a value between 0 and 100), where scores
// less than 3 are assigned a severity of 'low'.
const getSeverityColor = normalizedScore => {
  if (normalizedScore >= 75) {
    return '#fe5050';
  } else if (normalizedScore >= 50) {
    return '#fba740';
  } else if (normalizedScore >= 25) {
    return '#fdec25';
  } else if (normalizedScore >= 3) {
    return '#8bc8fb';
  } else if (normalizedScore >= 0) {
    return '#d2e9f7';
  } else {
    return '#ffffff';
  }
};
exports.getSeverityColor = getSeverityColor;