"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiPlugins = exports.processingPlugins = exports.platinumOnlyPluginTokens = exports.parsingPlugins = exports.nonStatefulUiPlugins = void 0;
var _eui = require("@elastic/eui");
var timelineMarkdownPlugin = _interopRequireWildcard(require("./timeline"));
var osqueryMarkdownPlugin = _interopRequireWildcard(require("./osquery"));
var insightMarkdownPlugin = _interopRequireWildcard(require("./insight"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nonStatefulUiPlugins = exports.nonStatefulUiPlugins = (0, _eui.getDefaultEuiMarkdownUiPlugins)();
const parsingPlugins = exports.parsingPlugins = (0, _eui.getDefaultEuiMarkdownParsingPlugins)();
const processingPlugins = exports.processingPlugins = (0, _eui.getDefaultEuiMarkdownProcessingPlugins)();
const platinumOnlyPluginTokens = exports.platinumOnlyPluginTokens = [insightMarkdownPlugin.insightPrefix];
const uiPlugins = ({
  insightsUpsellingMessage
}) => {
  const currentPlugins = nonStatefulUiPlugins.map(plugin => plugin.name);
  const insightPluginWithLicense = insightMarkdownPlugin.plugin({
    insightsUpsellingMessage
  });
  if (currentPlugins.includes(insightPluginWithLicense.name) === false) {
    nonStatefulUiPlugins.push(timelineMarkdownPlugin.plugin);
    nonStatefulUiPlugins.push(osqueryMarkdownPlugin.plugin);
    nonStatefulUiPlugins.push(insightPluginWithLicense);
  } else {
    // When called for the second time we need to update insightMarkdownPlugin
    const index = nonStatefulUiPlugins.findIndex(plugin => plugin.name === insightPluginWithLicense.name);
    nonStatefulUiPlugins[index] = insightPluginWithLicense;
  }
  return nonStatefulUiPlugins;
};
exports.uiPlugins = uiPlugins;
parsingPlugins.push(insightMarkdownPlugin.parser);
parsingPlugins.push(timelineMarkdownPlugin.parser);
parsingPlugins.push(osqueryMarkdownPlugin.parser);

// This line of code is TS-compatible and it will break if [1][1] change in the future.
processingPlugins[1][1].components.insight = insightMarkdownPlugin.renderer;
processingPlugins[1][1].components.timeline = timelineMarkdownPlugin.renderer;
processingPlugins[1][1].components.osquery = osqueryMarkdownPlugin.renderer;