"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WelcomeHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _translations = require("../translations");
var _welcome_header = require("../styles/welcome_header.styles");
var _use_project_features_url = require("../hooks/use_project_features_url");
var _kibana = require("../../../../lib/kibana");
var _current_plan = require("./current_plan");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WelcomeHeaderComponent = ({
  productTier
}) => {
  var _userName$fullName;
  const userName = (0, _kibana.useCurrentUser)();

  // Full name could be null, user name should always exist
  const name = (_userName$fullName = userName === null || userName === void 0 ? void 0 : userName.fullName) !== null && _userName$fullName !== void 0 ? _userName$fullName : userName === null || userName === void 0 ? void 0 : userName.username;
  const projectFeaturesUrl = (0, _use_project_features_url.useProjectFeaturesUrl)();
  const {
    headerContentStyles,
    headerStyles,
    headerTitleStyles,
    headerSubtitleStyles,
    headerDescriptionStyles
  } = (0, _welcome_header.useWelcomeHeaderStyles)();
  const headerSubtitleClassNames = (0, _classnames.default)('eui-displayBlock', headerSubtitleStyles);
  const headerDescriptionClassNames = (0, _classnames.default)('eui-displayBlock', headerDescriptionStyles);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: headerStyles,
    "data-test-subj": "welcome-header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: headerContentStyles
  }, name && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    className: headerTitleStyles,
    "data-test-subj": "welcome-header-greetings"
  }, /*#__PURE__*/_react.default.createElement("span", null, (0, _translations.GET_STARTED_PAGE_TITLE)(name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: headerSubtitleClassNames
  }, _translations.GET_STARTED_PAGE_SUBTITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: headerDescriptionClassNames
  }, _translations.GET_STARTED_PAGE_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_current_plan.CurrentPlan, {
    productTier: productTier,
    projectFeaturesUrl: projectFeaturesUrl
  })));
};
const WelcomeHeader = exports.WelcomeHeader = /*#__PURE__*/_react.default.memo(WelcomeHeaderComponent);