"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurrentPlan = void 0;
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _use_license = require("../../../../hooks/use_license");
var _kibana = require("../../../../lib/kibana");
var _current_plan = require("../styles/current_plan.styles");
var _translations = require("../translations");
var _current_plan_badge = require("./current_plan_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CurrentPlanComponent = ({
  productTier,
  projectFeaturesUrl
}) => {
  const licenseService = (0, _use_license.useLicense)();
  const licenseType = licenseService.getLicenseType();
  const isTrial = licenseType === 'trial';
  const isEnterprise = licenseService.isEnterprise() && !isTrial;
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const licenseManagementUrl = getAppUrl({
    appId: 'management',
    path: 'stack/license_management/home'
  });
  const currentPlan = productTier ? productTier : !(0, _fp.isEmpty)(licenseType) ? licenseType : undefined;
  const label = productTier ? _translations.CURRENT_TIER_LABEL : _translations.CURRENT_PLAN_LABEL;
  const link = productTier ? projectFeaturesUrl : licenseManagementUrl;
  const {
    currentPlanWrapperStyles,
    currentPlanTextStyles,
    projectFeaturesUrlStyles
  } = (0, _current_plan.useCurrentPlanStyles)();
  const currentPlanWrapperClassNames = (0, _classnames.default)('eui-displayInlineBlock', currentPlanWrapperStyles);
  const projectFeaturesUrlClassNames = (0, _classnames.default)('eui-alignMiddle', projectFeaturesUrlStyles);
  if (isEnterprise && productTier == null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", {
    className: currentPlanWrapperClassNames
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "currentPlanLabel",
    className: currentPlanTextStyles
  }, label), /*#__PURE__*/_react.default.createElement(_current_plan_badge.CurrentPlanBadge, {
    currentPlan: currentPlan
  }), link && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "currentPlanLink",
    className: projectFeaturesUrlClassNames,
    color: "primary",
    href: link,
    target: "_blank",
    "aria-label": label,
    iconType: "gear",
    size: "xs"
  }))));
};
const CurrentPlan = exports.CurrentPlan = /*#__PURE__*/_react.default.memo(CurrentPlanComponent);