"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TogglePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_setup_sections = require("./hooks/use_setup_sections");
var _step_context = require("./context/step_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TogglePanelComponent = ({
  activeSections,
  activeProducts
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    expandedCardSteps,
    finishedSteps,
    toggleTaskCompleteStatus,
    onStepClicked
  } = (0, _step_context.useStepContext)();
  const {
    setUpSections
  } = (0, _use_setup_sections.useSetUpSections)({
    euiTheme
  });
  const sectionNodes = (0, _react.useMemo)(() => setUpSections({
    activeSections,
    expandedCardSteps,
    finishedSteps,
    toggleTaskCompleteStatus,
    onStepClicked
  }), [activeSections, expandedCardSteps, finishedSteps, onStepClicked, setUpSections, toggleTaskCompleteStatus]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, activeProducts.size > 0 ? sectionNodes : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "magnifyWithExclamation",
    title: /*#__PURE__*/_react.default.createElement("h2", null, i18n.TOGGLE_PANEL_EMPTY_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, i18n.TOGGLE_PANEL_EMPTY_DESCRIPTION),
    css: (0, _css.css)`
              padding: ${euiTheme.base * 5}px 0;
              .euiEmptyPrompt__content {
                max-width: none;
              }
            `
  })));
};
const TogglePanel = exports.TogglePanel = /*#__PURE__*/_react.default.memo(TogglePanelComponent);