"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWelcomeHeaderStyles = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = require("react");
var _helpers = require("../helpers");
var _launch = _interopRequireDefault(require("../images/launch.png"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useWelcomeHeaderStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const welcomeHeaderStyles = (0, _react.useMemo)(() => {
    return {
      headerStyles: (0, _css.css)({
        backgroundImage: `url(${_launch.default})`,
        backgroundSize: '40%',
        backgroundRepeat: 'no-repeat',
        backgroundPositionX: 'right',
        backgroundPositionY: 'center',
        padding: `${euiTheme.base * 0.625}px 0`
      }),
      headerTitleStyles: (0, _css.css)({
        paddingBottom: euiTheme.size.s,
        fontSize: `${euiTheme.base}px`,
        color: euiTheme.colors.darkShade,
        fontWeight: euiTheme.font.weight.bold,
        lineHeight: euiTheme.size.l
      }),
      headerSubtitleStyles: (0, _css.css)({
        fontSize: `${euiTheme.base * 2.125}px`,
        color: euiTheme.colors.title,
        fontWeight: euiTheme.font.weight.bold,
        lineHeight: euiTheme.size.xxl
      }),
      headerDescriptionStyles: (0, _css.css)({
        fontSize: `${euiTheme.base}px`,
        color: euiTheme.colors.subduedText,
        lineHeight: euiTheme.size.l,
        fontWeight: euiTheme.font.weight.regular
      }),
      headerContentStyles: (0, _css.css)({
        width: `${_helpers.CONTENT_WIDTH / 2}px`
      })
    };
  }, [euiTheme.base, euiTheme.colors.darkShade, euiTheme.colors.subduedText, euiTheme.colors.title, euiTheme.font.weight.bold, euiTheme.font.weight.regular, euiTheme.size.l, euiTheme.size.s, euiTheme.size.xxl]);
  return welcomeHeaderStyles;
};
exports.useWelcomeHeaderStyles = useWelcomeHeaderStyles;