"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepContentStyles = exports.RIGHT_CONTENT_WIDTH = exports.RIGHT_CONTENT_PANEL_WIDTH = exports.LEFT_CONTENT_PANEL_WIDTH = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LEFT_CONTENT_PANEL_WIDTH = exports.LEFT_CONTENT_PANEL_WIDTH = 486;
const RIGHT_CONTENT_PANEL_WIDTH = exports.RIGHT_CONTENT_PANEL_WIDTH = 540;
const RIGHT_CONTENT_WIDTH = exports.RIGHT_CONTENT_WIDTH = 513;
const useStepContentStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const imageShadow = (0, _eui.useEuiShadow)('s');
  const customStyles = (0, _react.useMemo)(() => ({
    stepContentGroupStyles: (0, _css.css)({
      '&.step-content-group': {
        justifyContent: 'space-between',
        marginTop: euiTheme.size.l,
        padding: euiTheme.size.l,
        transition: `opacity ${euiTheme.animation.normal}`,
        overflow: 'hidden',
        border: `1px solid ${euiTheme.colors.lightShade}`,
        borderRadius: euiTheme.border.radius.medium
      }
    }),
    leftContentStyles: (0, _css.css)({
      '&.left-panel': {
        padding: `0 0 0 ${euiTheme.size.s}`,
        width: `${LEFT_CONTENT_PANEL_WIDTH}px`
      }
    }),
    descriptionStyles: (0, _css.css)({
      '&.step-content-description': {
        marginBottom: '0px',
        marginBlockEnd: '0px !important',
        lineHeight: euiTheme.size.l,
        '.step-paragraph': {
          marginTop: euiTheme.size.xl
        }
      }
    }),
    rightPanelStyles: (0, _css.css)({
      '&.right-panel': {
        padding: `0 6px 0 ${euiTheme.size.l}`,
        width: `${RIGHT_CONTENT_PANEL_WIDTH}px`
      }
    }),
    rightPanelContentStyles: (0, _css.css)({
      '&.right-panel-wrapper': {
        width: `${RIGHT_CONTENT_WIDTH}px`
      }
    }),
    getRightContentStyles: ({
      shadow
    }) => (0, _css.css)(`
          &.right-panel-content {
            height: 100%;
            width: 100%;
            position: relative;
            overflow: hidden;
            border-radius: ${euiTheme.border.radius.medium};
            ${shadow ? imageShadow : ''}
        }`)
  }), [euiTheme.animation.normal, euiTheme.border.radius.medium, euiTheme.colors.lightShade, euiTheme.size.l, euiTheme.size.s, euiTheme.size.xl, imageShadow]);
  return customStyles;
};
exports.useStepContentStyles = useStepContentStyles;