"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProgressBarStyles = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useProgressBarStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const progressBarStyles = (0, _react.useMemo)(() => ({
    textStyle: (0, _css.css)({
      fontSize: '10.5px',
      fontWeight: euiTheme.font.weight.bold,
      textTransform: 'uppercase'
    })
  }), [euiTheme.font.weight.bold]);
  return progressBarStyles;
};
exports.useProgressBarStyles = useProgressBarStyles;