"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOnboardingStyles = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOnboardingStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react.useMemo)(() => ({
    wrapperStyles: (0, _css.css)({
      margin: `0 -${euiTheme.size.l}`
    }),
    progressSectionStyles: (0, _css.css)({
      backgroundColor: euiTheme.colors.lightestShade,
      padding: `${euiTheme.size.xxl} ${euiTheme.size.xxl} ${euiTheme.size.m}`
    }),
    stepsSectionStyles: (0, _css.css)({
      padding: `0 ${euiTheme.size.xxl} ${euiTheme.size.xxxl}`,
      backgroundColor: euiTheme.colors.lightestShade
    })
  }), [euiTheme.colors.lightestShade, euiTheme.size.l, euiTheme.size.m, euiTheme.size.xxl, euiTheme.size.xxxl]);
};
exports.useOnboardingStyles = useOnboardingStyles;