"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCurrentPlanBadgeStyles = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCurrentPlanBadgeStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _react.useMemo)(() => {
    return {
      wrapperStyles: (0, _css.css)({
        fontSize: euiTheme.size.m,
        lineHeight: euiTheme.size.m
      }),
      textStyles: (0, _css.css)({
        textTransform: 'capitalize'
      })
    };
  }, [euiTheme.size.m]);
  return styles;
};
exports.useCurrentPlanBadgeStyles = useCurrentPlanBadgeStyles;