"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddIntegrationButtons = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _links = require("@kbn/security-solution-navigation/links");
var _eui = require("@elastic/eui");
var _types = require("../types");
var _step_context = require("../context/step_context");
var _types2 = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEE_INTEGRATIONS = _i18n.i18n.translate('xpack.securitySolution.onboarding.step.addIntegrations.seeIntegrationsButton', {
  defaultMessage: 'See integrations'
});
const ADD_CLOUD_INTEGRATIONS_TITLE = _i18n.i18n.translate('xpack.securitySolution.onboarding.step.addIntegrations.addCloudIntegrations.title', {
  defaultMessage: 'Add Cloud Security data'
});
const ADD_CLOUD_INTEGRATIONS_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.onboarding.step.addIntegrations.addCloudIntegrations.description', {
  defaultMessage: 'Cloud-specific security integrations'
});
const ADD_EDR_XDR_INTEGRATIONS_TITLE = _i18n.i18n.translate('xpack.securitySolution.onboarding.step.addIntegrations.addEdrXdrIntegrations.title', {
  defaultMessage: 'Add EDR/XDR data'
});
const ADD_EDR_XDR_INTEGRATIONS_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.onboarding.step.addIntegrations.addEdrXdrIntegrations.description', {
  defaultMessage: 'EDR/XDR-specific security integrations'
});
const ADD_ALL_INTEGRATIONS_TITLE = _i18n.i18n.translate('xpack.securitySolution.onboarding.step.addIntegrations.addAllIntegrations.title', {
  defaultMessage: 'All security integrations'
});
const ADD_ALL_INTEGRATIONS_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.onboarding.step.addIntegrations.addAllIntegrations.description', {
  defaultMessage: 'The full set of security integrations'
});
const CloudIntegrationsIcon = ({
  ...props
}) => /*#__PURE__*/_react.default.createElement("svg", (0, _extends2.default)({
  width: "32",
  height: "32",
  viewBox: "0 0 32 32",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
}, props), /*#__PURE__*/_react.default.createElement("path", {
  d: "M5.08008 18.7995C2.26902 18.7676 0 16.4581 0 13.6142C0 10.7504 2.30088 8.42882 5.13916 8.42882C5.15374 8.42882 5.16831 8.42888 5.18287 8.429C5.8371 4.10905 9.53542 0.799805 13.9998 0.799805C18.4641 0.799805 22.1624 4.10905 22.8167 8.429C22.8312 8.42888 22.8458 8.42882 22.8604 8.42882C25.6987 8.42882 27.9995 10.7504 27.9995 13.6142C27.9995 16.4581 25.7305 18.7676 22.9195 18.7995H5.08008Z",
  fill: "#343741"
}), /*#__PURE__*/_react.default.createElement("path", {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M5.00012 16.3996C12.1797 16.3996 17.9999 10.5794 17.9999 3.39986C17.9999 2.82316 17.9624 2.25523 17.8896 1.69839C16.714 1.12268 15.3942 0.799805 13.9998 0.799805C9.53542 0.799805 5.8371 4.10905 5.18287 8.429L5.13916 8.42882C2.30088 8.42882 0 10.7504 0 13.6142C0 14.2989 0.131541 14.9526 0.370513 15.5511C1.80873 16.0994 3.36936 16.3996 5.00012 16.3996Z",
  fill: "#0077CC"
}), /*#__PURE__*/_react.default.createElement("path", {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M22.8227 8.42887L22.8608 8.42871C25.6991 8.42871 28 10.7503 28 13.6141C28 16.4579 25.731 18.7675 22.9199 18.7994H16.8138C17.012 14.4375 19.3597 10.6359 22.8227 8.42887Z",
  fill: "#00BFB3"
}), /*#__PURE__*/_react.default.createElement("path", {
  d: "M23.6655 22.1415L23.9999 22.2602L24.3344 22.1415C24.7834 21.9821 25.2825 21.6651 25.7452 21.3081C26.2247 20.9382 26.7305 20.4743 27.194 19.9624C27.6559 19.4523 28.0945 18.874 28.4227 18.2721C28.7447 17.6815 28.9999 16.9964 28.9999 16.293V11.1992V10.1992H27.9999H20H19V11.1992V16.293C19 16.9964 19.2552 17.6815 19.5772 18.2721C19.9054 18.874 20.344 19.4523 20.8058 19.9624C21.2694 20.4743 21.7751 20.9382 22.2546 21.3081C22.7173 21.6651 23.2165 21.9821 23.6655 22.1415Z",
  fill: "#FA744E",
  stroke: "#F7F8FC",
  strokeWidth: "2"
}));
const EdrXdrIntegrationsIcon = ({
  ...props
}) => /*#__PURE__*/_react.default.createElement("svg", (0, _extends2.default)({
  width: "32",
  height: "32",
  viewBox: "0 0 32 32",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
}, props), /*#__PURE__*/_react.default.createElement("g", {
  clipPath: "url(#clip0_3269_21193)"
}, /*#__PURE__*/_react.default.createElement("path", {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M10.5 11.9997L4.404 1.68421C3.38775 -0.0370402 0.75 0.68446 0.75 2.68321V21.3162C0.75 23.315 3.38775 24.0365 4.404 22.3152L10.5 11.9997Z",
  fill: "#F04E98"
}), /*#__PURE__*/_react.default.createElement("path", {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M13.1133 12L12.4376 13.1445L6.34156 23.46C6.22681 23.6535 6.09706 23.8305 5.95831 24H12.8403C14.6508 24 16.3331 23.0677 17.2923 21.5325L23.2503 12H13.1133Z",
  fill: "#FA744E"
}), /*#__PURE__*/_react.default.createElement("path", {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M17.2924 2.4675C16.3332 0.93225 14.6509 0 12.8397 0H5.95844C6.09644 0.1695 6.22694 0.3465 6.34094 0.54L12.4369 10.8555L13.1134 12H23.2497L17.2924 2.4675Z",
  fill: "#343741"
})), /*#__PURE__*/_react.default.createElement("defs", null, /*#__PURE__*/_react.default.createElement("clipPath", {
  id: "clip0_3269_21193"
}, /*#__PURE__*/_react.default.createElement("rect", {
  width: "24",
  height: "24",
  fill: "white"
}))));
const AddIntegrationPanel = /*#__PURE__*/_react.default.memo(({
  title,
  description,
  buttonId,
  icon
}) => {
  const {
    onStepLinkClicked
  } = (0, _step_context.useStepContext)();
  const onClick = (0, _react.useCallback)(() => {
    onStepLinkClicked({
      originStepId: _types.AddIntegrationsSteps.connectToDataSources,
      stepLinkId: buttonId
    });
  }, [onStepLinkClicked, buttonId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("h4", null, title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    id: buttonId,
    onClick: onClick
  }, SEE_INTEGRATIONS))));
});
AddIntegrationPanel.displayName = 'AddIntegrationPanel';
const AddIntegrationButtons = exports.AddIntegrationButtons = /*#__PURE__*/_react.default.memo(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  className: "step-paragraph",
  gutterSize: "m"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(AddIntegrationPanel, {
  title: ADD_CLOUD_INTEGRATIONS_TITLE,
  description: ADD_CLOUD_INTEGRATIONS_DESCRIPTION,
  icon: CloudIntegrationsIcon,
  buttonId: _types2.IntegrationsPageName.integrationsSecurityCloud
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(AddIntegrationPanel, {
  title: ADD_EDR_XDR_INTEGRATIONS_TITLE,
  description: ADD_EDR_XDR_INTEGRATIONS_DESCRIPTION,
  icon: EdrXdrIntegrationsIcon,
  buttonId: _types2.IntegrationsPageName.integrationsSecurityEdrXrd
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(AddIntegrationPanel, {
  title: ADD_ALL_INTEGRATIONS_TITLE,
  description: ADD_ALL_INTEGRATIONS_DESCRIPTION,
  icon: "logoSecurity",
  buttonId: _types2.IntegrationsPageName.integrationsSecurity
}))));
AddIntegrationButtons.displayName = 'AddIntegrationButtons';