"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddElasticRulesButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _links = require("@kbn/security-solution-navigation/links");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _types = require("../types");
var _step_context = require("../context/step_context");
var _add_integration_callout = require("./add_integration_callout");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddElasticRulesButtonComponent = () => {
  var _finishedSteps$AddAnd;
  const {
    finishedSteps,
    onStepLinkClicked
  } = (0, _step_context.useStepContext)();
  const isIntegrationsStepComplete = (_finishedSteps$AddAnd = finishedSteps[_types.AddAndValidateYourDataCardsId.addIntegrations]) === null || _finishedSteps$AddAnd === void 0 ? void 0 : _finishedSteps$AddAnd.has(_types.AddIntegrationsSteps.connectToDataSources);
  const onClick = (0, _react.useCallback)(() => {
    onStepLinkClicked({
      originStepId: _types.EnablePrebuiltRulesSteps.enablePrebuiltRules,
      stepLinkId: _securitySolutionNavigation.SecurityPageName.rules
    });
  }, [onStepLinkClicked]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isIntegrationsStepComplete && /*#__PURE__*/_react.default.createElement(_add_integration_callout.AddIntegrationCallout, {
    stepName: _translations.ADD_ELASTIC_RULES_CALLOUT_TITLE,
    stepId: _types.EnablePrebuiltRulesSteps.enablePrebuiltRules
  }), /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    id: _securitySolutionNavigation.SecurityPageName.rules,
    fill: true,
    className: "step-paragraph",
    disabled: !isIntegrationsStepComplete,
    onClick: onClick
  }, _translations.ADD_ELASTIC_RULES));
};
const AddElasticRulesButton = exports.AddElasticRulesButton = /*#__PURE__*/_react.default.memo(AddElasticRulesButtonComponent);