"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.viewDashboardSteps = exports.viewAlertSteps = exports.sections = exports.overviewVideoSteps = exports.getSections = exports.getCardById = exports.enablePrebuildRuleSteps = exports.createProjectSteps = exports.addIntegrationsSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _types = require("./types");
var i18n = _interopRequireWildcard(require("./translations"));
var _add_integration_buttons = require("./step_links/add_integration_buttons");
var _alerts_link = require("./step_links/alerts_link");
var _add_elastic_rules_button = require("./step_links/add_elastic_rules_button");
var _dashboard_button = require("./step_links/dashboard_button");
var _overview_video = _interopRequireDefault(require("./images/overview_video.svg"));
var _video = require("./card_step/content/video");
var _overview_video_description = require("./card_step/content/overview_video_description");
var _manage_projects_button = require("./step_links/manage_projects_button");
var _enable_rule_image = require("./card_step/content/enable_rule_image");
var _helpers = require("./card_step/helpers");
var _view_dashboard_image = require("./card_step/content/view_dashboard_image");
var _add_integration_image = require("./card_step/content/add_integration_image");
var _create_project_step_image = require("./card_step/content/create_project_step_image");
var _view_alerts_image = require("./card_step/content/view_alerts_image");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createProjectSteps = exports.createProjectSteps = [{
  id: _types.CreateProjectSteps.createFirstProject,
  title: i18n.CREATE_PROJECT_TITLE,
  icon: {
    type: 'addDataApp',
    size: 'xl'
  },
  description: [i18n.CREATE_PROJECT_DESCRIPTION, /*#__PURE__*/_react.default.createElement(_manage_projects_button.ManageProjectsButton, null)],
  splitPanel: /*#__PURE__*/_react.default.createElement(_create_project_step_image.CreateProjectImage, null)
}];
const overviewVideoSteps = exports.overviewVideoSteps = [{
  icon: {
    type: _overview_video.default,
    size: 'xl'
  },
  title: i18n.WATCH_VIDEO_TITLE,
  id: _types.OverviewSteps.getToKnowElasticSecurity,
  description: [/*#__PURE__*/_react.default.createElement(_overview_video_description.OverviewVideoDescription, null)],
  splitPanel: /*#__PURE__*/_react.default.createElement(_video.Video, null)
}];
const addIntegrationsSteps = exports.addIntegrationsSteps = [{
  icon: {
    type: 'fleetApp',
    size: 'xl'
  },
  id: _types.AddIntegrationsSteps.connectToDataSources,
  title: i18n.ADD_INTEGRATIONS_TITLE,
  description: [i18n.ADD_INTEGRATIONS_DESCRIPTION, /*#__PURE__*/_react.default.createElement(_add_integration_buttons.AddIntegrationButtons, null)],
  splitPanel: /*#__PURE__*/_react.default.createElement(_add_integration_image.AddIntegrationsImage, null),
  autoCheckIfStepCompleted: _helpers.autoCheckAddIntegrationsStepCompleted
}];
const viewDashboardSteps = exports.viewDashboardSteps = [{
  id: _types.ViewDashboardSteps.analyzeData,
  icon: {
    type: 'dashboardApp',
    size: 'xl'
  },
  title: i18n.VIEW_DASHBOARDS,
  description: [i18n.VIEW_DASHBOARDS_DESCRIPTION, /*#__PURE__*/_react.default.createElement(_dashboard_button.DashboardButton, null)],
  splitPanel: /*#__PURE__*/_react.default.createElement(_view_dashboard_image.ViewDashboardImage, null)
}];
const enablePrebuildRuleSteps = exports.enablePrebuildRuleSteps = [{
  title: i18n.ENABLE_RULES,
  icon: {
    type: 'advancedSettingsApp',
    size: 'xl'
  },
  id: _types.EnablePrebuiltRulesSteps.enablePrebuiltRules,
  description: [i18n.ENABLE_RULES_DESCRIPTION, /*#__PURE__*/_react.default.createElement(_add_elastic_rules_button.AddElasticRulesButton, null)],
  splitPanel: /*#__PURE__*/_react.default.createElement(_enable_rule_image.EnableRuleImage, null),
  autoCheckIfStepCompleted: _helpers.autoCheckPrebuildRuleStepCompleted
}];
const viewAlertSteps = exports.viewAlertSteps = [{
  icon: {
    type: 'watchesApp',
    size: 'xl'
  },
  title: i18n.VIEW_ALERTS_TITLE,
  id: _types.ViewAlertsSteps.viewAlerts,
  description: [i18n.VIEW_ALERTS_DESCRIPTION, /*#__PURE__*/_react.default.createElement(_alerts_link.AlertsButton, null)],
  splitPanel: /*#__PURE__*/_react.default.createElement(_view_alerts_image.ViewAlertsImage, null)
}];
const sections = exports.sections = [{
  id: _types.SectionId.quickStart,
  title: i18n.SECTION_1_TITLE,
  cards: [{
    id: _types.QuickStartSectionCardsId.createFirstProject,
    steps: createProjectSteps,
    hideSteps: true
  }, {
    id: _types.QuickStartSectionCardsId.watchTheOverviewVideo,
    steps: overviewVideoSteps
  }]
}, {
  id: _types.SectionId.addAndValidateYourData,
  title: i18n.SECTION_2_TITLE,
  cards: [{
    id: _types.AddAndValidateYourDataCardsId.addIntegrations,
    steps: addIntegrationsSteps
  }, {
    id: _types.AddAndValidateYourDataCardsId.viewDashboards,
    steps: viewDashboardSteps
  }]
}, {
  id: _types.SectionId.getStartedWithAlerts,
  title: i18n.SECTION_3_TITLE,
  cards: [{
    id: _types.GetStartedWithAlertsCardsId.enablePrebuiltRules,
    steps: enablePrebuildRuleSteps
  }, {
    id: _types.GetStartedWithAlertsCardsId.viewAlerts,
    steps: viewAlertSteps
  }]
}];
const getSections = () => sections;
exports.getSections = getSections;
const getCardById = stepId => {
  const cards = sections.flatMap(s => s.cards);
  return cards.find(c => {
    var _c$steps;
    return (_c$steps = c.steps) === null || _c$steps === void 0 ? void 0 : _c$steps.find(step => stepId === step.id);
  });
};
exports.getCardById = getCardById;