"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Progress = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _translations = require("./translations");
var _progress_bar = require("./styles/progress_bar.style");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProgressComponent = ({
  productTier,
  totalActiveSteps,
  totalStepsLeft
}) => {
  const stepsDone = totalActiveSteps != null && totalStepsLeft != null ? totalActiveSteps - totalStepsLeft : null;
  const {
    textStyle
  } = (0, _progress_bar.useProgressBarStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, totalActiveSteps != null && totalStepsLeft != null && stepsDone != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: stepsDone,
    max: totalActiveSteps,
    size: "m",
    label: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("span", {
      className: textStyle
    }, _translations.PROGRESS_TRACKER_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })),
    valueText: /*#__PURE__*/_react.default.createElement("span", {
      className: textStyle
    }, `${stepsDone}/${totalActiveSteps}`)
  })));
};
const Progress = exports.Progress = /*#__PURE__*/_react.default.memo(ProgressComponent);