"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.OnboardingWithSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_space_id = require("../../../hooks/use_space_id");
var _use_available_steps = require("./hooks/use_available_steps");
var _use_product_types = require("./hooks/use_product_types");
var _onboarding = require("./onboarding");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OnboardingWithSettingsComponent = ({
  indicesExist
}) => {
  const productTypes = (0, _use_product_types.useProductTypes)();
  const onboardingSteps = (0, _use_available_steps.useAvailableSteps)();
  const spaceId = (0, _use_space_id.useSpaceId)();

  /* spaceId returns undefined if the space is loading.
   ** We render the onboarding component only when spaceId is ready
   ** to make sure it reads the local storage data with the correct spaceId.
   */
  if (!onboardingSteps || !spaceId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_onboarding.Onboarding, {
    indicesExist: indicesExist,
    productTypes: productTypes,
    onboardingSteps: onboardingSteps,
    spaceId: spaceId
  });
};
const OnboardingWithSettings = exports.OnboardingWithSettings = /*#__PURE__*/_react.default.memo(OnboardingWithSettingsComponent);

// eslint-disable-next-line import/no-default-export
var _default = exports.default = OnboardingWithSettings;