"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Footer = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _footer = require("../styles/footer.styles");
var _footer2 = require("./footer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FooterComponent = () => {
  const {
    wrapperStyle,
    titleStyle,
    descriptionStyle,
    linkStyle
  } = (0, _footer.useFooterStyles)();
  const footer = (0, _react.useMemo)(() => (0, _footer2.getFooter)(), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "none",
    className: wrapperStyle
  }, footer.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `footer-${item.key}`
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: item.icon,
    alt: item.title,
    height: "64",
    width: "64"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("p", {
    className: titleStyle
  }, item.title), /*#__PURE__*/_react.default.createElement("p", {
    className: descriptionStyle
  }, item.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: item.link.href,
    external: true,
    target: "_blank",
    className: linkStyle
  }, item.link.title))));
};
const Footer = exports.Footer = /*#__PURE__*/_react.default.memo(FooterComponent);