"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHADOW_ANIMATION_DURATION = exports.CardItem = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _helpers = require("./helpers");
var _card_step = require("./card_step");
var _card_item = require("./styles/card_item.styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHADOW_ANIMATION_DURATION = exports.SHADOW_ANIMATION_DURATION = 350;
const CardItemComponent = ({
  activeStepIds,
  cardId,
  expandedCardSteps,
  finishedSteps,
  toggleTaskCompleteStatus,
  onStepClicked,
  sectionId
}) => {
  const isExpandedCard = expandedCardSteps[cardId].isExpanded;
  const cardItem = (0, _react.useMemo)(() => (0, _helpers.getCard)({
    cardId,
    sectionId
  }), [cardId, sectionId]);
  const expandedSteps = (0, _react.useMemo)(() => {
    var _expandedCardSteps$ca, _expandedCardSteps$ca2;
    return new Set((_expandedCardSteps$ca = (_expandedCardSteps$ca2 = expandedCardSteps[cardId]) === null || _expandedCardSteps$ca2 === void 0 ? void 0 : _expandedCardSteps$ca2.expandedSteps) !== null && _expandedCardSteps$ca !== void 0 ? _expandedCardSteps$ca : []);
  }, [cardId, expandedCardSteps]);
  const cardItemPanelStyle = (0, _card_item.useCardItemStyles)();
  const cardClassNames = (0, _classnames.default)('card-item', {
    'card-expanded': isExpandedCard
  }, cardItemPanelStyle);
  const getCardStep = (0, _react.useCallback)(stepId => {
    var _cardItem$steps;
    return cardItem === null || cardItem === void 0 ? void 0 : (_cardItem$steps = cardItem.steps) === null || _cardItem$steps === void 0 ? void 0 : _cardItem$steps.find(step => step.id === stepId);
  }, [cardItem === null || cardItem === void 0 ? void 0 : cardItem.steps]);
  const steps = (0, _react.useMemo)(() => activeStepIds === null || activeStepIds === void 0 ? void 0 : activeStepIds.reduce((acc, stepId) => {
    const step = getCardStep(stepId);
    if (step && cardItem) {
      acc.push( /*#__PURE__*/_react.default.createElement(_card_step.CardStep, {
        cardId: cardItem.id,
        expandedSteps: expandedSteps,
        finishedSteps: finishedSteps,
        key: stepId,
        toggleTaskCompleteStatus: toggleTaskCompleteStatus,
        onStepClicked: onStepClicked,
        sectionId: sectionId,
        step: step
      }));
    }
    return acc;
  }, []), [activeStepIds, cardItem, expandedSteps, finishedSteps, getCardStep, onStepClicked, sectionId, toggleTaskCompleteStatus]);
  return cardItem && activeStepIds ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: cardClassNames,
    hasBorder: true,
    paddingSize: "none",
    borderRadius: "none",
    "data-test-subj": cardId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, steps))) : null;
};
CardItemComponent.displayName = 'CardItemComponent';
const CardItem = exports.CardItem = /*#__PURE__*/_react.default.memo(CardItemComponent);