"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProductBadges = exports.edrBadge = exports.cloudBadge = exports.analyticsBadge = void 0;
var _configs = require("./configs");
var _translations = require("./translations");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const analyticsBadge = exports.analyticsBadge = {
  id: _types.BadgeId.analytics,
  name: _translations.PRODUCT_BADGE_ANALYTICS
};
const cloudBadge = exports.cloudBadge = {
  id: _types.BadgeId.cloud,
  name: _translations.PRODUCT_BADGE_CLOUD
};
const edrBadge = exports.edrBadge = {
  id: _types.BadgeId.edr,
  name: _translations.PRODUCT_BADGE_EDR
};
const productBadges = {
  [_configs.ProductLine.security]: analyticsBadge,
  [_configs.ProductLine.cloud]: cloudBadge,
  [_configs.ProductLine.endpoint]: edrBadge
};
const getProductBadges = productLineRequired => (productLineRequired !== null && productLineRequired !== void 0 ? productLineRequired : [_configs.ProductLine.security, _configs.ProductLine.cloud, _configs.ProductLine.endpoint]).map(product => productBadges[product]);
exports.getProductBadges = getProductBadges;