"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PinEventAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("../../../timelines/components/timeline/styles");
var _helpers = require("../../../timelines/components/timeline/body/helpers");
var _user_privileges = require("../user_privileges");
var _ = require(".");
var _pin = require("../../../timelines/components/timeline/pin");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PinEventActionComponent = ({
  ariaLabel,
  isAlert,
  noteIds,
  onPinClicked,
  eventIsPinned,
  timelineType
}) => {
  const {
    kibanaSecuritySolutionsPrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const tooltipContent = (0, _react.useMemo)(() => (0, _helpers.getPinTooltip)({
    isPinned: eventIsPinned,
    isAlert,
    eventHasNotes: (0, _helpers.eventHasNotes)(noteIds),
    timelineType
  }), [eventIsPinned, isAlert, noteIds, timelineType]);
  return /*#__PURE__*/_react.default.createElement("div", {
    key: "timeline-action-pin-tool-tip"
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
    textAlign: "center",
    width: _.DEFAULT_ACTION_BUTTON_WIDTH
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "timeline-action-pin-tool-tip",
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement(_pin.Pin, {
    ariaLabel: ariaLabel,
    allowUnpinning: !(0, _helpers.eventHasNotes)(noteIds),
    "data-test-subj": "pin-event",
    isDisabled: kibanaSecuritySolutionsPrivileges.crud === false,
    isAlert: isAlert,
    onClick: onPinClicked,
    pinned: eventIsPinned,
    timelineType: timelineType
  }))));
};
PinEventActionComponent.displayName = 'PinEventActionComponent';
const PinEventAction = exports.PinEventAction = /*#__PURE__*/_react.default.memo(PinEventActionComponent);