"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddEventNoteAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../../../timelines/components/timeline/properties/helpers");
var _timeline = require("../../../../common/api/timeline");
var _user_privileges = require("../user_privileges");
var i18n = _interopRequireWildcard(require("./translations"));
var _action_icon_item = require("./action_icon_item");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddEventNoteActionComponent = ({
  ariaLabel,
  showNotes,
  timelineType,
  toggleShowNotes
}) => {
  const {
    kibanaSecuritySolutionsPrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  return /*#__PURE__*/_react.default.createElement(_action_icon_item.ActionIconItem, null, /*#__PURE__*/_react.default.createElement(_helpers.NotesButton, {
    ariaLabel: ariaLabel,
    "data-test-subj": "add-note",
    isDisabled: kibanaSecuritySolutionsPrivileges.crud === false,
    showNotes: showNotes,
    timelineType: timelineType,
    toggleShowNotes: toggleShowNotes,
    toolTip: timelineType === _timeline.TimelineType.template ? i18n.NOTES_DISABLE_TOOLTIP : i18n.NOTES_TOOLTIP
  }));
};
AddEventNoteActionComponent.displayName = 'AddEventNoteActionComponent';
const AddEventNoteAction = exports.AddEventNoteAction = /*#__PURE__*/_react.default.memo(AddEventNoteActionComponent);