"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Actions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _helpers = require("../../../timelines/components/timeline/body/helpers");
var _helpers2 = require("../../../helpers");
var _investigate_in_resolver = require("../../../detections/components/alerts_table/timeline_actions/investigate_in_resolver");
var _store = require("../../../timelines/store");
var _types = require("../../../../common/types");
var _add_note_icon_item = require("./add_note_icon_item");
var _pin_event_action = require("./pin_event_action");
var _use_selector = require("../../hooks/use_selector");
var _defaults = require("../../../timelines/store/defaults");
var _use_start_transaction = require("../../lib/apm/use_start_transaction");
var _use_license = require("../../hooks/use_license");
var _use_full_screen = require("../../containers/use_full_screen");
var _user_actions = require("../../lib/apm/user_actions");
var _actions = require("../../../timelines/store/actions");
var _styles = require("../../../timelines/components/timeline/styles");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _alert_context_menu = require("../../../detections/components/alerts_table/timeline_actions/alert_context_menu");
var _investigate_in_timeline_action = require("../../../detections/components/alerts_table/timeline_actions/investigate_in_timeline_action");
var i18n = _interopRequireWildcard(require("./translations"));
var _guided_onboarding_tour = require("../guided_onboarding_tour");
var _tour_config = require("../guided_onboarding_tour/tour_config");
var _helpers3 = require("../top_n/helpers");
var _tour_step = require("../guided_onboarding_tour/tour_step");
var _helpers4 = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionsContainer = _styledComponents.default.div`
  align-items: center;
  display: flex;
`;
const ActionsComponent = ({
  ariaRowindex,
  checked,
  columnValues,
  ecsData,
  eventId,
  eventIdToNoteIds,
  isEventPinned = false,
  isEventViewer = false,
  loadingEventIds,
  onEventDetailsPanelOpened,
  onRowSelected,
  onRuleChange,
  showCheckboxes,
  showNotes,
  timelineId,
  toggleShowNotes,
  refetch,
  setEventsLoading
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const tGridEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('tGridEnabled');
  const emptyNotes = [];
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const timelineType = (0, _use_selector.useShallowEqualSelector)(state => ((0, _helpers2.isTimelineScope)(timelineId) ? getTimeline(state, timelineId) : _defaults.timelineDefaults).timelineType);
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const onPinEvent = (0, _react.useCallback)(evtId => dispatch(_store.timelineActions.pinEvent({
    id: timelineId,
    eventId: evtId
  })), [dispatch, timelineId]);
  const onUnPinEvent = (0, _react.useCallback)(evtId => dispatch(_store.timelineActions.unPinEvent({
    id: timelineId,
    eventId: evtId
  })), [dispatch, timelineId]);
  const handleSelectEvent = (0, _react.useCallback)(event => onRowSelected({
    eventIds: [eventId],
    isSelected: event.currentTarget.checked
  }), [eventId, onRowSelected]);
  const handlePinClicked = (0, _react.useCallback)(() => (0, _helpers.getPinOnClick)({
    allowUnpinning: eventIdToNoteIds ? !(0, _helpers.eventHasNotes)(eventIdToNoteIds[eventId]) : true,
    eventId,
    onPinEvent,
    onUnPinEvent,
    isEventPinned
  }), [eventIdToNoteIds, eventId, isEventPinned, onPinEvent, onUnPinEvent]);
  const eventType = (0, _helpers.getEventType)(ecsData);
  const isContextMenuDisabled = (0, _react.useMemo)(() => {
    var _ecsData$event, _ecsData$event$kind, _ecsData$agent, _ecsData$agent$type;
    return eventType !== 'signal' && !((_ecsData$event = ecsData.event) !== null && _ecsData$event !== void 0 && (_ecsData$event$kind = _ecsData$event.kind) !== null && _ecsData$event$kind !== void 0 && _ecsData$event$kind.includes('event') && (_ecsData$agent = ecsData.agent) !== null && _ecsData$agent !== void 0 && (_ecsData$agent$type = _ecsData$agent.type) !== null && _ecsData$agent$type !== void 0 && _ecsData$agent$type.includes('endpoint'));
  }, [ecsData, eventType]);
  const isDisabled = !(0, _investigate_in_resolver.useIsInvestigateInResolverActionEnabled)(ecsData);
  const {
    setGlobalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    setTimelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const handleClick = (0, _react.useCallback)(() => {
    startTransaction({
      name: _user_actions.ALERTS_ACTIONS.OPEN_ANALYZER
    });
    const scopedActions = (0, _helpers2.getScopedActions)(timelineId);
    const dataGridIsFullScreen = document.querySelector('.euiDataGrid--fullScreen');
    if (scopedActions) {
      dispatch(scopedActions.updateGraphEventId({
        id: timelineId,
        graphEventId: ecsData._id
      }));
    }
    if (timelineId === _types.TimelineId.active) {
      if (dataGridIsFullScreen) {
        setTimelineFullScreen(true);
      }
      dispatch((0, _actions.setActiveTabTimeline)({
        id: timelineId,
        activeTab: _securitysolutionDataTable.TimelineTabs.graph
      }));
    } else {
      if (dataGridIsFullScreen) {
        setGlobalFullScreen(true);
      }
    }
  }, [startTransaction, timelineId, dispatch, ecsData._id, setTimelineFullScreen, setGlobalFullScreen]);
  const sessionViewConfig = (0, _react.useMemo)(() => {
    var _process$entry_leader, _process$entry_leader2, _process$entry_leader3, _process$entry_leader4, _kibana$alert, _kibana$alert$ancesto, _kibana$alert$ancesto2, _process$entity_id, _ecsData$kibana, _ecsData$kibana$alert;
    const {
      process,
      _id,
      _index,
      timestamp,
      kibana
    } = ecsData;
    const sessionEntityId = process === null || process === void 0 ? void 0 : (_process$entry_leader = process.entry_leader) === null || _process$entry_leader === void 0 ? void 0 : (_process$entry_leader2 = _process$entry_leader.entity_id) === null || _process$entry_leader2 === void 0 ? void 0 : _process$entry_leader2[0];
    const sessionStartTime = process === null || process === void 0 ? void 0 : (_process$entry_leader3 = process.entry_leader) === null || _process$entry_leader3 === void 0 ? void 0 : (_process$entry_leader4 = _process$entry_leader3.start) === null || _process$entry_leader4 === void 0 ? void 0 : _process$entry_leader4[0];
    const index = (kibana === null || kibana === void 0 ? void 0 : (_kibana$alert = kibana.alert) === null || _kibana$alert === void 0 ? void 0 : (_kibana$alert$ancesto = _kibana$alert.ancestors) === null || _kibana$alert$ancesto === void 0 ? void 0 : (_kibana$alert$ancesto2 = _kibana$alert$ancesto.index) === null || _kibana$alert$ancesto2 === void 0 ? void 0 : _kibana$alert$ancesto2[0]) || _index;
    if (index === undefined || sessionEntityId === undefined || sessionStartTime === undefined) {
      return null;
    }
    const jumpToEntityId = process === null || process === void 0 ? void 0 : (_process$entity_id = process.entity_id) === null || _process$entity_id === void 0 ? void 0 : _process$entity_id[0];
    const investigatedAlertId = eventType === 'signal' || eventType === 'eql' ? _id : undefined;
    const jumpToCursor = investigatedAlertId && ((_ecsData$kibana = ecsData.kibana) === null || _ecsData$kibana === void 0 ? void 0 : (_ecsData$kibana$alert = _ecsData$kibana.alert.original_time) === null || _ecsData$kibana$alert === void 0 ? void 0 : _ecsData$kibana$alert[0]) || timestamp;
    return {
      index,
      sessionEntityId,
      sessionStartTime,
      jumpToEntityId,
      jumpToCursor,
      investigatedAlertId
    };
  }, [ecsData, eventType]);
  const openSessionView = (0, _react.useCallback)(() => {
    const dataGridIsFullScreen = document.querySelector('.euiDataGrid--fullScreen');
    startTransaction({
      name: _user_actions.ALERTS_ACTIONS.OPEN_SESSION_VIEW
    });
    const scopedActions = (0, _helpers2.getScopedActions)(timelineId);
    if (timelineId === _types.TimelineId.active) {
      if (dataGridIsFullScreen) {
        setTimelineFullScreen(true);
      }
      if (sessionViewConfig !== null) {
        dispatch((0, _actions.setActiveTabTimeline)({
          id: timelineId,
          activeTab: _securitysolutionDataTable.TimelineTabs.session
        }));
      }
    } else {
      if (dataGridIsFullScreen) {
        setGlobalFullScreen(true);
      }
    }
    if (sessionViewConfig !== null) {
      if (scopedActions) {
        dispatch(scopedActions.updateSessionViewConfig({
          id: timelineId,
          sessionViewConfig
        }));
      }
    }
  }, [startTransaction, timelineId, sessionViewConfig, setTimelineFullScreen, dispatch, setGlobalFullScreen]);
  const {
    activeStep,
    isTourShown,
    incrementStep
  } = (0, _guided_onboarding_tour.useTourContext)();
  const isTourAnchor = (0, _react.useMemo)(() => isTourShown(_tour_config.SecurityStepId.alertsCases) && eventType === 'signal' && (0, _helpers3.isDetectionsAlertsTable)(timelineId) && ariaRowindex === 1, [isTourShown, ariaRowindex, eventType, timelineId]);
  const onExpandEvent = (0, _react.useCallback)(() => {
    if (isTourAnchor && activeStep === _tour_config.AlertsCasesTourSteps.expandEvent && isTourShown(_tour_config.SecurityStepId.alertsCases)) {
      incrementStep(_tour_config.SecurityStepId.alertsCases);
    }
    onEventDetailsPanelOpened();
  }, [activeStep, incrementStep, isTourAnchor, isTourShown, onEventDetailsPanelOpened]);
  return /*#__PURE__*/_react.default.createElement(ActionsContainer, null, showCheckboxes && !tGridEnabled && /*#__PURE__*/_react.default.createElement("div", {
    key: "select-event-container",
    "data-test-subj": "select-event-container"
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
    textAlign: "center",
    width: _helpers4.DEFAULT_ACTION_BUTTON_WIDTH
  }, loadingEventIds.includes(eventId) ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": "event-loader"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "aria-label": i18n.CHECKBOX_FOR_ROW({
      ariaRowindex,
      columnValues,
      checked
    }),
    "data-test-subj": "select-event",
    id: eventId,
    checked: checked,
    onChange: handleSelectEvent
  }))), /*#__PURE__*/_react.default.createElement(_tour_step.GuidedOnboardingTourStep, {
    isTourAnchor: isTourAnchor,
    onClick: onExpandEvent,
    step: _tour_config.AlertsCasesTourSteps.expandEvent,
    tourId: _tour_config.SecurityStepId.alertsCases
  }, /*#__PURE__*/_react.default.createElement("div", {
    key: "expand-event"
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
    textAlign: "center",
    width: _helpers4.DEFAULT_ACTION_BUTTON_WIDTH
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "expand-event-tool-tip",
    content: i18n.VIEW_DETAILS
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.VIEW_DETAILS_FOR_ROW({
      ariaRowindex,
      columnValues
    }),
    "data-test-subj": "expand-event",
    iconType: "expand",
    onClick: onExpandEvent,
    size: "s"
  }))))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, timelineId !== _types.TimelineId.active && /*#__PURE__*/_react.default.createElement(_investigate_in_timeline_action.InvestigateInTimelineAction, {
    ariaLabel: i18n.SEND_ALERT_TO_TIMELINE_FOR_ROW({
      ariaRowindex,
      columnValues
    }),
    key: "investigate-in-timeline",
    ecsRowData: ecsData
  }), !isEventViewer && toggleShowNotes && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_add_note_icon_item.AddEventNoteAction, {
    ariaLabel: i18n.ADD_NOTES_FOR_ROW({
      ariaRowindex,
      columnValues
    }),
    key: "add-event-note",
    showNotes: showNotes !== null && showNotes !== void 0 ? showNotes : false,
    toggleShowNotes: toggleShowNotes,
    timelineType: timelineType
  }), /*#__PURE__*/_react.default.createElement(_pin_event_action.PinEventAction, {
    ariaLabel: i18n.PIN_EVENT_FOR_ROW({
      ariaRowindex,
      columnValues,
      isEventPinned
    }),
    isAlert: (0, _helpers4.isAlert)(eventType),
    key: "pin-event",
    onPinClicked: handlePinClicked,
    noteIds: eventIdToNoteIds ? eventIdToNoteIds[eventId] || emptyNotes : emptyNotes,
    eventIsPinned: isEventPinned,
    timelineType: timelineType
  })), /*#__PURE__*/_react.default.createElement(_alert_context_menu.AlertContextMenu, {
    ariaLabel: i18n.MORE_ACTIONS_FOR_ROW({
      ariaRowindex,
      columnValues
    }),
    ariaRowindex: ariaRowindex,
    columnValues: columnValues,
    key: "alert-context-menu",
    ecsRowData: ecsData,
    scopeId: timelineId,
    disabled: isContextMenuDisabled,
    onRuleChange: onRuleChange,
    refetch: refetch
  }), isDisabled === false ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
    textAlign: "center",
    width: _helpers4.DEFAULT_ACTION_BUTTON_WIDTH
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "view-in-analyzer-tool-tip",
    content: i18n.ACTION_INVESTIGATE_IN_RESOLVER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.ACTION_INVESTIGATE_IN_RESOLVER_FOR_ROW({
      ariaRowindex,
      columnValues
    }),
    "data-test-subj": "view-in-analyzer",
    iconType: "analyzeEvent",
    onClick: handleClick,
    size: "s"
  })))) : null, sessionViewConfig !== null && (isEnterprisePlus || timelineId === _securitysolutionDataTable.TableId.kubernetesPageSessions) ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
    textAlign: "center",
    width: _helpers4.DEFAULT_ACTION_BUTTON_WIDTH
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "expand-event-tool-tip",
    content: i18n.OPEN_SESSION_VIEW
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.VIEW_DETAILS_FOR_ROW({
      ariaRowindex,
      columnValues
    }),
    "data-test-subj": "session-view-button",
    iconType: "sessionViewer",
    onClick: openSessionView,
    size: "s"
  })))) : null));
};
ActionsComponent.displayName = 'ActionsComponent';
const Actions = exports.Actions = /*#__PURE__*/_react.default.memo(ActionsComponent);