"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventsViewerSelector = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _reselect = require("reselect");
var _selectors = require("../../../store/inputs/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This selector is invoked with two arguments:
 * @param state - the state of the store as defined by State in common/store/types.ts
 * @param id - a timeline id e.g. `alerts-page`
 *
 * Example:
 *  `useSelector((state: State) => eventsViewerSelector(state, id))`
 */
const eventsViewerSelector = exports.eventsViewerSelector = (0, _reselect.createSelector)((0, _selectors.globalFiltersQuerySelector)(), (0, _selectors.getTimelineSelector)(), (0, _selectors.globalQuerySelector)(), (0, _selectors.globalQuery)(), (0, _selectors.timelineQueryByIdSelector)(), (0, _securitysolutionDataTable.getTableByIdSelector)(), (filters, input, query, globalQueries, timelineQuery, dataTable) => ({
  /** an array representing filters added to the search bar */
  filters,
  /** an object containing the timerange set in the global date picker, and other page level state */
  input,
  /** a serialized representation of the KQL / Lucence query in the search bar */
  query,
  /** an array of objects with metadata and actions related to queries on the page */
  globalQueries,
  /** an object with metadata and actions related to the table query */
  timelineQuery,
  /** a specific data table from the state's tableById collection, or undefined */
  dataTable
}));