"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RightTopMenu = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _inspect = require("../inspect");
var _styles = require("./styles");
var _summary_view_select = require("./summary_view_select");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TitleText = _styledComponents.default.span`
  margin-right: 12px;
`;
const RightTopMenu = ({
  tableView,
  loading,
  tableId,
  title,
  onViewChange,
  additionalFilters,
  hasRightOffset,
  showInspect = true,
  position = 'absolute',
  additionalMenuOptions = []
}) => {
  const alignItems = tableView === 'gridView' ? 'baseline' : 'center';
  const justTitle = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(TitleText, {
    "data-test-subj": "title"
  }, title), [title]);
  const tGridEventRenderedViewEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('tGridEventRenderedViewEnabled');
  const menuOptions = (0, _react.useMemo)(() => additionalMenuOptions.length ? additionalMenuOptions.map((additionalMenuOption, i) => /*#__PURE__*/_react.default.createElement(_styles.UpdatedFlexItem, {
    grow: false,
    $show: !loading,
    key: i
  }, additionalMenuOption)) : null, [additionalMenuOptions, loading]);
  return /*#__PURE__*/_react.default.createElement(_styles.UpdatedFlexGroup, {
    alignItems: alignItems,
    "data-test-subj": "events-viewer-updated",
    gutterSize: "m",
    component: "span",
    justifyContent: "flexEnd",
    direction: "row",
    $hasRightOffset: hasRightOffset,
    position: position
  }, showInspect ? /*#__PURE__*/_react.default.createElement(_styles.UpdatedFlexItem, {
    grow: false,
    $show: !loading
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    title: justTitle,
    queryId: tableId
  })) : null, /*#__PURE__*/_react.default.createElement(_styles.UpdatedFlexItem, {
    grow: false,
    $show: !loading
  }, additionalFilters), tGridEventRenderedViewEnabled && [_securitysolutionDataTable.TableId.alertsOnRuleDetailsPage, _securitysolutionDataTable.TableId.alertsOnAlertsPage].includes(tableId) && /*#__PURE__*/_react.default.createElement(_styles.UpdatedFlexItem, {
    grow: false,
    $show: !loading,
    "data-test-subj": "summary-view-selector"
  }, /*#__PURE__*/_react.default.createElement(_summary_view_select.SummaryViewSelector, {
    viewSelected: tableView,
    onViewChange: onViewChange
  })), menuOptions);
};
exports.RightTopMenu = RightTopMenu;