"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubtitleFunction = exports.eventsStackByOptions = exports.eventsHistogramConfig = exports.alertsStackByOptions = exports.alertsHistogramConfig = void 0;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _external_alert = require("../visualization_actions/lens_attributes/common/external_alert");
var _events = require("../visualization_actions/lens_attributes/common/events");
var i18n = _interopRequireWildcard(require("./translations"));
var _eventsStackByOptions, _alertsStackByOptions;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_EVENTS_STACK_BY = 'event.action';
const getSubtitleFunction = (defaultNumberFormat, isAlert) => totalCount => `${i18n.SHOWING}: ${(0, _numeral.default)(totalCount).format(defaultNumberFormat)} ${isAlert ? i18n.EXTERNAL_ALERTS_UNIT(totalCount) : i18n.EVENTS_UNIT(totalCount)}`;
exports.getSubtitleFunction = getSubtitleFunction;
const eventsStackByOptions = exports.eventsStackByOptions = [{
  text: 'event.action',
  value: 'event.action'
}, {
  text: 'event.dataset',
  value: 'event.dataset'
}, {
  text: 'event.module',
  value: 'event.module'
}];
const eventsHistogramConfig = exports.eventsHistogramConfig = {
  defaultStackByOption: (_eventsStackByOptions = eventsStackByOptions.find(o => o.text === DEFAULT_EVENTS_STACK_BY)) !== null && _eventsStackByOptions !== void 0 ? _eventsStackByOptions : eventsStackByOptions[0],
  stackByOptions: eventsStackByOptions,
  subtitle: undefined,
  title: i18n.EVENTS_GRAPH_TITLE,
  getLensAttributes: _events.getEventsHistogramLensAttributes
};
const alertsStackByOptions = exports.alertsStackByOptions = [{
  text: 'event.category',
  value: 'event.category'
}, {
  text: 'event.module',
  value: 'event.module'
}];
const DEFAULT_STACK_BY = 'event.module';
const alertsHistogramConfig = exports.alertsHistogramConfig = {
  defaultStackByOption: (_alertsStackByOptions = alertsStackByOptions.find(o => o.text === DEFAULT_STACK_BY)) !== null && _alertsStackByOptions !== void 0 ? _alertsStackByOptions : alertsStackByOptions[0],
  stackByOptions: alertsStackByOptions,
  title: i18n.ALERTS_GRAPH_TITLE,
  getLensAttributes: _external_alert.getExternalAlertLensAttributes
};