"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleAlertTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _formatted_date = require("../../formatted_date");
var _severity_badge = require("../../severity_badge");
var _use_alerts_by_ids = require("../../../containers/alerts/use_alerts_by_ids");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TABLE_FIELDS = ['@timestamp', 'kibana.alert.rule.name', 'kibana.alert.severity'];
const columns = [{
  field: 'kibana.alert.rule.name',
  name: 'Rule'
}, {
  field: '@timestamp',
  name: '@timestamp',
  render: timestamp => /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: new Date(timestamp)
  })
}, {
  field: 'kibana.alert.severity',
  name: 'Severity',
  render: severity => /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
    value: severity
  })
}];

/** 10 alert rows in this table has been deemed a balanced amount for the flyout */
const alertLimit = 10;

/**
 * Displays a simplified alert table for the given alert ids.
 * It will only fetch the latest 10 ids and in case more ids
 * are passed in, it will add a note about omitted alerts.
 */
const SimpleAlertTable = exports.SimpleAlertTable = /*#__PURE__*/_react.default.memo(({
  alertIds
}) => {
  const sampledData = (0, _react.useMemo)(() => alertIds.slice(0, alertLimit), [alertIds]);
  const {
    loading,
    error,
    data
  } = (0, _use_alerts_by_ids.useAlertsByIds)({
    alertIds: sampledData,
    fields: TABLE_FIELDS
  });
  const mappedData = (0, _react.useMemo)(() => {
    if (!data) {
      return undefined;
    }
    return data.map(doc => doc.fields);
  }, [data]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 2
    });
  } else if (error) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.SIMPLE_ALERT_TABLE_ERROR);
  } else if (mappedData) {
    const showLimitedDataNote = alertIds.length > alertLimit;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showLimitedDataNote && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("em", null, _translations.SIMPLE_ALERT_TABLE_LIMITED), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      compressed: true,
      items: mappedData,
      columns: columns
    }));
  }
  return null;
});
SimpleAlertTable.displayName = 'SimpleAlertTable';