"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Insights = void 0;
exports.hasCorrectAgentTypeAndEventModule = hasCorrectAgentTypeAndEventModule;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _fp = require("lodash/fp");
var _common2 = require("../../../../../common");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
var _use_experimental_features = require("../../../hooks/use_experimental_features");
var _use_license = require("../../../hooks/use_license");
var _related_alerts_by_process_ancestry = require("./related_alerts_by_process_ancestry");
var _related_cases = require("./related_cases");
var _related_alerts_by_source_event = require("./related_alerts_by_source_event");
var _related_alerts_by_session = require("./related_alerts_by_session");
var _related_alerts_upsell = require("./related_alerts_upsell");
var _kibana = require("../../../lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledInsightItem = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  border: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
  padding: 10px 8px;
  border-radius: 6px;
  display: inline-flex;
`;
/**
 * Displays several key insights for the associated alert.
 */
const Insights = exports.Insights = /*#__PURE__*/_react.default.memo(({
  browserFields,
  eventId,
  data,
  isReadOnly,
  scopeId
}) => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const isRelatedAlertsByProcessAncestryEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('insightsRelatedAlertsByProcessAncestry');
  const hasAtLeastPlatinum = (0, _use_license.useLicense)().isPlatinumPlus();
  const originalDocumentId = (0, _fp.find)({
    category: 'kibana',
    field: 'kibana.alert.ancestors.id'
  }, data);
  const originalDocumentIndex = (0, _fp.find)({
    category: 'kibana',
    field: 'kibana.alert.rule.parameters.index'
  }, data);
  const agentTypeField = (0, _fp.find)({
    category: 'agent',
    field: 'agent.type'
  }, data);
  const eventModuleField = (0, _fp.find)({
    category: 'event',
    field: 'event.module'
  }, data);
  const processEntityField = (0, _fp.find)({
    category: 'process',
    field: 'process.entity_id'
  }, data);
  const hasProcessEntityInfo = (0, _helpers.hasData)(processEntityField) && hasCorrectAgentTypeAndEventModule(agentTypeField, eventModuleField);
  const processSessionField = (0, _fp.find)({
    category: 'process',
    field: 'process.entry_leader.entity_id'
  }, data);
  const hasProcessSessionInfo = isRelatedAlertsByProcessAncestryEnabled && (0, _helpers.hasData)(processSessionField);
  const sourceEventField = (0, _fp.find)({
    category: 'kibana',
    field: 'kibana.alert.original_event.id'
  }, data);
  const hasSourceEventInfo = (0, _helpers.hasData)(sourceEventField);
  const alertSuppressionField = (0, _fp.find)({
    category: 'kibana',
    field: _ruleDataUtils.ALERT_SUPPRESSION_DOCS_COUNT
  }, data);
  const hasAlertSuppressionField = (0, _helpers.hasData)(alertSuppressionField);
  const userCasesPermissions = cases.helpers.canUseCases([_common2.APP_ID]);
  const hasCasesReadPermissions = userCasesPermissions.read;

  // Make sure that the alert has at least one of the associated fields
  // or the user has the required permissions for features/fields that
  // we can provide insights for
  const canShowAtLeastOneInsight = hasCasesReadPermissions || hasProcessEntityInfo || hasSourceEventInfo || hasProcessSessionInfo;
  const canShowAncestryInsight = isRelatedAlertsByProcessAncestryEnabled && hasProcessEntityInfo && originalDocumentId && originalDocumentIndex;

  // If we're in read-only mode or don't have any insight-related data,
  // don't render anything.
  if (isReadOnly || !canShowAtLeastOneInsight) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.INSIGHTS))), hasAlertSuppressionField && /*#__PURE__*/_react.default.createElement(StyledInsightItem, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "layers",
    style: {
      marginLeft: '4px',
      marginRight: '8px'
    }
  }), i18n.SUPPRESSED_ALERTS_COUNT(parseInt(alertSuppressionField.values[0], 10)), /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: i18n.SUPPRESSED_ALERTS_COUNT_TECHNICAL_PREVIEW,
    style: {
      verticalAlign: 'middle',
      marginLeft: '8px'
    },
    size: "s"
  }))), hasCasesReadPermissions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_related_cases.RelatedCases, {
    eventId: eventId
  })), sourceEventField && sourceEventField.values && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_related_alerts_by_source_event.RelatedAlertsBySourceEvent, {
    browserFields: browserFields,
    data: sourceEventField,
    eventId: eventId,
    scopeId: scopeId
  })), processSessionField && processSessionField.values && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "related-alerts-by-session"
  }, /*#__PURE__*/_react.default.createElement(_related_alerts_by_session.RelatedAlertsBySession, {
    browserFields: browserFields,
    data: processSessionField,
    eventId: eventId,
    scopeId: scopeId
  })), canShowAncestryInsight && (hasAtLeastPlatinum ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "related-alerts-by-ancestry"
  }, /*#__PURE__*/_react.default.createElement(_related_alerts_by_process_ancestry.RelatedAlertsByProcessAncestry, {
    originalDocumentId: originalDocumentId,
    index: originalDocumentIndex,
    eventId: eventId,
    scopeId: scopeId
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_related_alerts_upsell.RelatedAlertsUpsell, null)))));
});
function hasCorrectAgentTypeAndEventModule(agentTypeField, eventModuleField) {
  return (0, _helpers.hasData)(agentTypeField) && (agentTypeField.values[0] === 'endpoint' || agentTypeField.values[0] === 'winlogbeat' && (0, _helpers.hasData)(eventModuleField) && eventModuleField.values[0] === 'sysmon');
}
Insights.displayName = 'Insights';