"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsViewType = exports.EventDetails = exports.EVENT_DETAILS_CONTEXT_ID = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var _helpers = require("../../../timelines/components/side_panel/event_details/helpers");
var _use_rule_with_fallback = require("../../../detection_engine/rule_management/logic/use_rule_with_fallback");
var _response_actions_view = require("./response_actions_view");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _get_mitre_threat_component = require("../../../detections/mitre/get_mitre_threat_component");
var _tour_step = require("../guided_onboarding_tour/tour_step");
var _helpers2 = require("../top_n/helpers");
var _tour_config = require("../guided_onboarding_tour/tour_config");
var _event_fields_browser = require("./event_fields_browser");
var _json_view = require("./json_view");
var _threat_summary_view = require("./cti_details/threat_summary_view");
var _threat_details_view = require("./cti_details/threat_details_view");
var i18n = _interopRequireWildcard(require("./translations"));
var _alert_summary_view = require("./alert_summary_view");
var _event_enrichment = require("../../containers/cti/event_enrichment");
var _helpers3 = require("./cti_details/helpers");
var _enrichment_range_picker = require("./cti_details/enrichment_range_picker");
var _investigation_guide_view = require("./investigation_guide_view");
var _overview = require("./overview");
var _insights = require("./insights/insights");
var _use_risk_score_data = require("../../../entity_analytics/api/hooks/use_risk_score_data");
var _get_row_renderer = require("../../../timelines/components/timeline/body/renderers/get_row_renderer");
var _helpers4 = require("../../../timelines/components/timeline/body/renderers/helpers");
var _renderers = require("../../../timelines/components/timeline/body/renderers");
var _osquery_tab = require("./osquery_tab");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EVENT_DETAILS_CONTEXT_ID = exports.EVENT_DETAILS_CONTEXT_ID = 'event-details';
let EventsViewType = exports.EventsViewType = /*#__PURE__*/function (EventsViewType) {
  EventsViewType["tableView"] = "table-view";
  EventsViewType["jsonView"] = "json-view";
  EventsViewType["summaryView"] = "summary-view";
  EventsViewType["threatIntelView"] = "threat-intel-view";
  EventsViewType["osqueryView"] = "osquery-results-view";
  EventsViewType["responseActionsView"] = "response-actions-results-view";
  return EventsViewType;
}({});
const StyledEuiTabbedContent = (0, _styledComponents.default)(_eui.EuiTabbedContent)`
  display: flex;
  flex: 1;
  flex-direction: column;
  overflow: hidden;

  > [role='tabpanel'] {
    display: flex;
    flex: 1;
    flex-direction: column;
    overflow: hidden;
    overflow-y: auto;

    ::-webkit-scrollbar {
      -webkit-appearance: none;
      width: 7px;
    }

    ::-webkit-scrollbar-thumb {
      border-radius: 4px;
      background-color: rgba(0, 0, 0, 0.5);
      -webkit-box-shadow: 0 0 1px rgba(255, 255, 255, 0.5);
    }
  }
`;
const TabContentWrapper = _styledComponents.default.div`
  height: 100%;
  position: relative;
`;
const RendererContainer = _styledComponents.default.div`
  overflow-x: auto;
  padding-right: ${props => props.theme.eui.euiSizeXS};

  & .${_helpers4.DETAILS_CLASS_NAME} .euiFlexGroup {
    justify-content: flex-start;
  }
`;
const ThreatTacticContainer = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  flex-grow: 0;
  flex-wrap: nowrap;

  & .euiFlexGroup {
    flex-wrap: nowrap;
  }
`;
const ThreatTacticDescription = _styledComponents.default.div`
  padding-left: ${props => props.theme.eui.euiSizeL};
`;
const EventDetailsComponent = ({
  browserFields,
  data,
  detailsEcsData,
  id,
  isAlert,
  isDraggable,
  rawEventData,
  scopeId,
  timelineTabType,
  handleOnEventClosed,
  isReadOnly
}) => {
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(EventsViewType.summaryView);
  const handleTabClick = (0, _react.useCallback)(tab => setSelectedTabId(tab.id), []);
  const goToTableTab = (0, _react.useCallback)(() => setSelectedTabId(EventsViewType.tableView), []);
  const eventFields = (0, _react.useMemo)(() => (0, _helpers3.getEnrichmentFields)(data), [data]);
  const basicAlertData = (0, _helpers.useBasicDataFromDetailsData)(data);
  const {
    rule: maybeRule
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(basicAlertData.ruleId);
  const existingEnrichments = (0, _react.useMemo)(() => isAlert ? (0, _helpers3.parseExistingEnrichments)(data).map(enrichmentData => (0, _helpers3.timelineDataToEnrichment)(enrichmentData)) : [], [data, isAlert]);
  const {
    result: enrichmentsResponse,
    loading: isEnrichmentsLoading,
    setRange,
    range
  } = (0, _event_enrichment.useInvestigationTimeEnrichment)(eventFields);
  const threatDetails = (0, _react.useMemo)(() => (0, _get_mitre_threat_component.getMitreComponentParts)(rawEventData), [rawEventData]);
  const allEnrichments = (0, _react.useMemo)(() => {
    if (isEnrichmentsLoading || !(enrichmentsResponse !== null && enrichmentsResponse !== void 0 && enrichmentsResponse.enrichments)) {
      return existingEnrichments;
    }
    return (0, _helpers3.filterDuplicateEnrichments)([...existingEnrichments, ...enrichmentsResponse.enrichments]);
  }, [isEnrichmentsLoading, enrichmentsResponse, existingEnrichments]);
  const enrichmentCount = allEnrichments.length;
  const {
    hostRisk,
    userRisk,
    isAuthorized
  } = (0, _use_risk_score_data.useRiskScoreData)(data);
  const renderer = (0, _react.useMemo)(() => detailsEcsData != null ? (0, _get_row_renderer.getRowRenderer)({
    data: detailsEcsData,
    rowRenderers: _renderers.defaultRowRenderers
  }) : null, [detailsEcsData]);
  const isTourAnchor = (0, _react.useMemo)(() => (0, _helpers2.isDetectionsAlertsTable)(scopeId), [scopeId]);
  const showThreatSummary = (0, _react.useMemo)(() => {
    const hasEnrichments = enrichmentCount > 0;
    const hasRiskInfoWithLicense = isAuthorized && (hostRisk || userRisk);
    return hasEnrichments || hasRiskInfoWithLicense;
  }, [enrichmentCount, hostRisk, isAuthorized, userRisk]);
  const endpointResponseActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointResponseActionsEnabled');
  const summaryTab = (0, _react.useMemo)(() => {
    var _maybeRule$investigat, _maybeRule$investigat2;
    return isAlert ? {
      id: EventsViewType.summaryView,
      name: i18n.OVERVIEW,
      'data-test-subj': 'overviewTab',
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_overview.Overview, {
        browserFields: browserFields,
        contextId: scopeId,
        data: data,
        eventId: id,
        scopeId: scopeId,
        handleOnEventClosed: handleOnEventClosed,
        isReadOnly: isReadOnly
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), threatDetails && threatDetails[0] && /*#__PURE__*/_react.default.createElement(ThreatTacticContainer, {
        alignItems: "flexStart",
        direction: "column",
        wrap: false,
        gutterSize: "none"
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xxs"
      }, /*#__PURE__*/_react.default.createElement("h5", null, threatDetails[0].title)), /*#__PURE__*/_react.default.createElement(ThreatTacticDescription, null, threatDetails[0].description))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), renderer != null && detailsEcsData != null && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.ALERT_REASON)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(RendererContainer, {
        "data-test-subj": "renderer"
      }, renderer.renderRow({
        contextId: EVENT_DETAILS_CONTEXT_ID,
        data: detailsEcsData,
        isDraggable: isDraggable !== null && isDraggable !== void 0 ? isDraggable : false,
        scopeId
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_alert_summary_view.AlertSummaryView, {
        data,
        eventId: id,
        browserFields,
        isDraggable,
        scopeId,
        title: i18n.HIGHLIGHTED_FIELDS,
        isReadOnly,
        goToTable: goToTableTab,
        investigationFields: (_maybeRule$investigat = maybeRule === null || maybeRule === void 0 ? void 0 : (_maybeRule$investigat2 = maybeRule.investigation_fields) === null || _maybeRule$investigat2 === void 0 ? void 0 : _maybeRule$investigat2.field_names) !== null && _maybeRule$investigat !== void 0 ? _maybeRule$investigat : []
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xl"
      }), /*#__PURE__*/_react.default.createElement(_insights.Insights, {
        browserFields: browserFields,
        eventId: id,
        data: data,
        scopeId: scopeId,
        isReadOnly: isReadOnly
      }), showThreatSummary && /*#__PURE__*/_react.default.createElement(_threat_summary_view.ThreatSummaryView, {
        isDraggable: isDraggable,
        hostRisk: hostRisk,
        userRisk: userRisk,
        browserFields: browserFields,
        data: data,
        eventId: id,
        scopeId: scopeId,
        enrichments: allEnrichments,
        isReadOnly: isReadOnly
      }), isEnrichmentsLoading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 2
      })), basicAlertData.ruleId && (maybeRule === null || maybeRule === void 0 ? void 0 : maybeRule.note) && /*#__PURE__*/_react.default.createElement(_investigation_guide_view.InvestigationGuideView, {
        basicData: basicAlertData,
        ruleNote: maybeRule.note
      }))
    } : undefined;
  }, [isAlert, browserFields, scopeId, data, id, handleOnEventClosed, isReadOnly, threatDetails, renderer, detailsEcsData, isDraggable, goToTableTab, maybeRule === null || maybeRule === void 0 ? void 0 : maybeRule.investigation_fields, maybeRule === null || maybeRule === void 0 ? void 0 : maybeRule.note, showThreatSummary, hostRisk, userRisk, allEnrichments, isEnrichmentsLoading, basicAlertData]);
  const threatIntelTab = (0, _react.useMemo)(() => isAlert && !isReadOnly ? {
    id: EventsViewType.threatIntelView,
    'data-test-subj': 'threatIntelTab',
    name: i18n.THREAT_INTEL,
    append: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEnrichmentsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      "data-test-subj": "enrichment-count-notification"
    }, enrichmentCount)),
    content: /*#__PURE__*/_react.default.createElement(_threat_details_view.ThreatDetailsView, {
      before: /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }),
      loading: isEnrichmentsLoading,
      enrichments: allEnrichments,
      showInvestigationTimeEnrichments: !(0, _lodash.isEmpty)(eventFields)
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_enrichment_range_picker.EnrichmentRangePicker, {
      setRange: setRange,
      loading: isEnrichmentsLoading,
      range: range
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })))
  } : undefined, [allEnrichments, setRange, range, enrichmentCount, isAlert, eventFields, isEnrichmentsLoading, isReadOnly]);
  const tableTab = (0, _react.useMemo)(() => ({
    id: EventsViewType.tableView,
    'data-test-subj': 'tableTab',
    name: i18n.TABLE,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_event_fields_browser.EventFieldsBrowser, {
      browserFields: browserFields,
      data: data,
      eventId: id,
      isDraggable: isDraggable,
      scopeId: scopeId,
      timelineTabType: timelineTabType,
      isReadOnly: isReadOnly
    }))
  }), [browserFields, data, id, isDraggable, scopeId, timelineTabType, isReadOnly]);
  const jsonTab = (0, _react.useMemo)(() => ({
    id: EventsViewType.jsonView,
    'data-test-subj': 'jsonViewTab',
    name: i18n.JSON_VIEW,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(TabContentWrapper, {
      "data-test-subj": "jsonViewWrapper"
    }, /*#__PURE__*/_react.default.createElement(_json_view.JsonView, {
      rawEventData: rawEventData
    })))
  }), [rawEventData]);
  const responseActionsTab = (0, _response_actions_view.useResponseActionsView)({
    rawEventData: rawEventData,
    ...(detailsEcsData !== null ? {
      ecsData: detailsEcsData
    } : {})
  });
  const osqueryTab = (0, _osquery_tab.useOsqueryTab)({
    rawEventData: rawEventData,
    ...(detailsEcsData !== null ? {
      ecsData: detailsEcsData
    } : {})
  });
  const responseActionsTabs = (0, _react.useMemo)(() => {
    return endpointResponseActionsEnabled ? [responseActionsTab] : [osqueryTab];
  }, [endpointResponseActionsEnabled, osqueryTab, responseActionsTab]);
  const tabs = (0, _react.useMemo)(() => {
    return [summaryTab, threatIntelTab, tableTab, jsonTab, ...responseActionsTabs].filter(tab => !!tab);
  }, [summaryTab, threatIntelTab, tableTab, jsonTab, responseActionsTabs]);
  const selectedTab = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(tab => tab.id === selectedTabId)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
  }, [tabs, selectedTabId]);
  const tourAnchor = (0, _react.useMemo)(() => isTourAnchor ? {
    'tour-step': (0, _tour_config.getTourAnchor)(3, _tour_config.SecurityStepId.alertsCases)
  } : {}, [isTourAnchor]);
  return /*#__PURE__*/_react.default.createElement(_tour_step.GuidedOnboardingTourStep, {
    isTourAnchor: isTourAnchor,
    step: _tour_config.AlertsCasesTourSteps.reviewAlertDetailsFlyout,
    tourId: _tour_config.SecurityStepId.alertsCases
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(StyledEuiTabbedContent, (0, _extends2.default)({}, tourAnchor, {
    "data-test-subj": "eventDetails",
    tabs: tabs,
    selectedTab: selectedTab,
    onTabClick: handleTabClick,
    key: "event-summary-tabs"
  }))));
};
EventDetailsComponent.displayName = 'EventDetailsComponent';
const EventDetails = exports.EventDetails = /*#__PURE__*/_react.default.memo(EventDetailsComponent);