"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatSummaryView = exports.ThreatSummaryPanelHeader = exports.EnrichedDataRow = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _risk_summary = require("../../../../entity_analytics/components/risk_summary");
var _enrichment_summary = require("./enrichment_summary");
var _search_strategy = require("../../../../../common/search_strategy");
var _helper_hooks = require("../../../../helper_hooks");
var _common = require("../../../../overview/components/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UppercaseEuiTitle = (0, _styledComponents.default)(_eui.EuiTitle)`
  text-transform: uppercase;
`;
const ThreatSummaryPanelTitle = ({
  children
}) => /*#__PURE__*/_react.default.createElement(UppercaseEuiTitle, {
  size: "xxxs"
}, /*#__PURE__*/_react.default.createElement("h5", null, children));
const StyledEnrichmentFieldTitle = (0, _styledComponents.default)(_eui.EuiTitle)`
  width: 220px;
`;
const EnrichmentFieldTitle = ({
  title
}) => /*#__PURE__*/_react.default.createElement(StyledEnrichmentFieldTitle, {
  size: "xxxs"
}, /*#__PURE__*/_react.default.createElement("h6", null, title));
const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  margin-top: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const EnrichedDataRow = ({
  field,
  value
}) => /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
  direction: "row",
  gutterSize: "none",
  responsive: true,
  alignItems: "center",
  "data-test-subj": "EnrichedDataRow"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  style: {
    flexShrink: 0
  },
  grow: false
}, /*#__PURE__*/_react.default.createElement(EnrichmentFieldTitle, {
  title: field
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  className: "eui-textBreakWord"
}, value));
exports.EnrichedDataRow = EnrichedDataRow;
const ThreatSummaryPanelHeader = ({
  title,
  toolTipContent,
  toolTipTitle
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ThreatSummaryPanelTitle, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_common.RiskScoreInfoTooltip, {
    toolTipContent: toolTipContent,
    toolTipTitle: toolTipTitle !== null && toolTipTitle !== void 0 ? toolTipTitle : title
  })));
};
exports.ThreatSummaryPanelHeader = ThreatSummaryPanelHeader;
const ThreatSummaryViewComponent = ({
  browserFields,
  data,
  enrichments,
  eventId,
  scopeId,
  hostRisk,
  userRisk,
  isDraggable,
  isReadOnly
}) => {
  var _data$find, _data$find$values, _data$find2, _data$find2$values;
  const originalHostRisk = data === null || data === void 0 ? void 0 : (_data$find = data.find(eventDetail => (eventDetail === null || eventDetail === void 0 ? void 0 : eventDetail.field) === 'host.risk.calculated_level')) === null || _data$find === void 0 ? void 0 : (_data$find$values = _data$find.values) === null || _data$find$values === void 0 ? void 0 : _data$find$values[0];
  const originalUserRisk = data === null || data === void 0 ? void 0 : (_data$find2 = data.find(eventDetail => (eventDetail === null || eventDetail === void 0 ? void 0 : eventDetail.field) === 'user.risk.calculated_level')) === null || _data$find2 === void 0 ? void 0 : (_data$find2$values = _data$find2.values) === null || _data$find2$values === void 0 ? void 0 : _data$find2$values[0];
  const hasEntityAnalyticsCapability = (0, _helper_hooks.useHasSecurityCapability)('entity-analytics');
  if (!hasEntityAnalyticsCapability && enrichments.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.ENRICHED_DATA)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    style: {
      flexGrow: 0
    }
  }, hasEntityAnalyticsCapability && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_risk_summary.RiskSummary, {
    riskEntity: _search_strategy.RiskScoreEntity.host,
    risk: hostRisk,
    originalRisk: originalHostRisk
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_risk_summary.RiskSummary, {
    riskEntity: _search_strategy.RiskScoreEntity.user,
    risk: userRisk,
    originalRisk: originalUserRisk
  }))), /*#__PURE__*/_react.default.createElement(_enrichment_summary.EnrichmentSummary, {
    browserFields: browserFields,
    data: data,
    enrichments: enrichments,
    scopeId: scopeId,
    eventId: eventId,
    isDraggable: isDraggable,
    isReadOnly: isReadOnly
  })));
};
const ThreatSummaryView = exports.ThreatSummaryView = /*#__PURE__*/_react.default.memo(ThreatSummaryViewComponent);