"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledEuiFlexGroup = exports.EnrichmentSummary = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _cell_actions = require("../../cell_actions");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
var _formatted_field = require("../../../../timelines/components/timeline/body/renderers/formatted_field");
var _threat_summary_view = require("./threat_summary_view");
var _helpers2 = require("../../../../helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnrichmentFieldFeedName = _styledComponents.default.span`
  white-space: nowrap;
  font-style: italic;
`;
const StyledEuiFlexGroup = exports.StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  .inlineActions {
    opacity: 0;
  }

  .inlineActions-popoverOpen {
    opacity: 1;
  }

  &:hover {
    .inlineActions {
      opacity: 1;
    }
  }
`;
const EnrichmentDescription = ({
  browserField,
  data,
  eventId,
  index,
  feedName,
  scopeId,
  value,
  isDraggable,
  isReadOnly
}) => {
  const metadata = (0, _react.useMemo)(() => ({
    scopeId
  }), [scopeId]);
  if (!data || !value) return null;
  const key = `alert-details-value-formatted-field-value-${scopeId}-${eventId}-${data.field}-${value}-${index}-${feedName}`;
  return /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    key: key,
    direction: "row",
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
    contextId: scopeId,
    eventId: key,
    fieldFormat: data.format,
    fieldName: data.field,
    fieldType: data.type,
    isDraggable: isDraggable,
    isObjectArray: data.isObjectArray,
    value: value,
    truncate: false
  }), feedName && /*#__PURE__*/_react.default.createElement(EnrichmentFieldFeedName, null, ' ', i18n.FEED_NAME_PREPOSITION, " ", feedName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, value && !isReadOnly && /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    data: {
      field: data.field,
      value
    },
    triggerId: _cell_actions.SecurityCellActionsTrigger.DETAILS_FLYOUT,
    mode: _cell_actions.CellActionsMode.INLINE,
    sourcererScopeId: (0, _helpers2.getSourcererScopeId)(scopeId),
    metadata: metadata,
    visibleCellActions: 3
  })));
};
const EnrichmentSummaryComponent = ({
  browserFields,
  data,
  enrichments,
  scopeId,
  eventId,
  isDraggable,
  isReadOnly
}) => {
  const parsedEnrichments = enrichments.map((enrichment, index) => {
    var _eventData$category, _browserField$format, _browserField$type, _eventData$isObjectAr;
    const {
      field,
      type,
      feedName,
      value
    } = (0, _helpers.getEnrichmentIdentifiers)(enrichment);
    const eventData = data.find(item => item.field === field);
    const category = (_eventData$category = eventData === null || eventData === void 0 ? void 0 : eventData.category) !== null && _eventData$category !== void 0 ? _eventData$category : '';
    const browserField = (0, _fp.get)([category, 'fields', field !== null && field !== void 0 ? field : ''], browserFields);
    const fieldsData = {
      field: field !== null && field !== void 0 ? field : '',
      format: (_browserField$format = browserField === null || browserField === void 0 ? void 0 : browserField.format) !== null && _browserField$format !== void 0 ? _browserField$format : '',
      type: (_browserField$type = browserField === null || browserField === void 0 ? void 0 : browserField.type) !== null && _browserField$type !== void 0 ? _browserField$type : '',
      isObjectArray: (_eventData$isObjectAr = eventData === null || eventData === void 0 ? void 0 : eventData.isObjectArray) !== null && _eventData$isObjectAr !== void 0 ? _eventData$isObjectAr : false
    };
    return {
      fieldsData,
      type,
      feedName,
      index,
      field,
      browserField,
      value
    };
  });
  const [investigation, indicator] = (0, _lodash.partition)(parsedEnrichments, ({
    type
  }) => (0, _helpers.isInvestigationTimeEnrichment)(type));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicator.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "s",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_threat_summary_view.ThreatSummaryPanelHeader, {
    title: i18n.INDICATOR_ENRICHMENT_TITLE,
    toolTipContent: i18n.INDICATOR_TOOLTIP_CONTENT
  }), indicator.map(({
    fieldsData,
    index,
    field,
    feedName,
    browserField,
    value
  }) => /*#__PURE__*/_react.default.createElement(_threat_summary_view.EnrichedDataRow, {
    key: field,
    field: field,
    value: /*#__PURE__*/_react.default.createElement(EnrichmentDescription, {
      eventId: eventId,
      index: index,
      feedName: feedName,
      scopeId: scopeId,
      value: value,
      data: fieldsData,
      browserField: browserField,
      isDraggable: isDraggable,
      isReadOnly: isReadOnly
    })
  })))), investigation.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "s",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_threat_summary_view.ThreatSummaryPanelHeader, {
    title: i18n.INVESTIGATION_ENRICHMENT_TITLE,
    toolTipContent: i18n.INVESTIGATION_TOOLTIP_CONTENT
  }), investigation.map(({
    fieldsData,
    index,
    field,
    feedName,
    browserField,
    value
  }) => /*#__PURE__*/_react.default.createElement(_threat_summary_view.EnrichedDataRow, {
    key: field,
    field: field,
    value: /*#__PURE__*/_react.default.createElement(EnrichmentDescription, {
      eventId: eventId,
      index: index,
      feedName: feedName,
      scopeId: scopeId,
      value: value,
      data: fieldsData,
      browserField: browserField,
      isDraggable: isDraggable,
      isReadOnly: isReadOnly
    })
  })))));
};
const EnrichmentSummary = exports.EnrichmentSummary = /*#__PURE__*/_react.default.memo(EnrichmentSummaryComponent);