"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldFromBrowserField = exports.getColumns = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _cell_actions = require("../cell_actions");
var i18n = _interopRequireWildcard(require("./translations"));
var _field_value_cell = require("./table/field_value_cell");
var _field_name_cell = require("./table/field_name_cell");
var _helpers = require("../../../helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HoverActionsContainer = (0, _styledComponents.default)(_eui.EuiPanel)`
  align-items: center;
  display: flex;
  flex-direction: row;
  height: 25px;
  justify-content: center;
  left: 5px;
  position: absolute;
  top: -10px;
  width: 30px;
`;
HoverActionsContainer.displayName = 'HoverActionsContainer';
const getFieldFromBrowserField = exports.getFieldFromBrowserField = (0, _memoizeOne.default)((keys, browserFields) => (0, _lodash.get)(browserFields, keys), (newArgs, lastArgs) => newArgs[0].join() === lastArgs[0].join());
const getColumns = ({
  browserFields,
  eventId,
  contextId,
  scopeId,
  getLinkValue,
  isDraggable,
  isReadOnly
}) => [...(!isReadOnly ? [{
  field: 'values',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, i18n.ACTIONS)),
  sortable: false,
  truncateText: false,
  width: '132px',
  render: (values, data) => {
    return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        field: data.field,
        value: values
      },
      triggerId: _cell_actions.SecurityCellActionsTrigger.DETAILS_FLYOUT,
      mode: _cell_actions.CellActionsMode.INLINE,
      visibleCellActions: 3,
      sourcererScopeId: (0, _helpers.getSourcererScopeId)(scopeId),
      metadata: {
        scopeId,
        isObjectArray: data.isObjectArray
      }
    });
  }
}] : []), {
  field: 'field',
  className: 'eventFieldsTable__fieldNameCell',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, i18n.FIELD)),
  sortable: true,
  truncateText: false,
  render: (field, data) => {
    return /*#__PURE__*/_react.default.createElement(_field_name_cell.FieldNameCell, {
      data: data,
      field: field,
      fieldMapping: undefined
    });
  }
}, {
  field: 'values',
  className: 'eventFieldsTable__fieldValueCell',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, i18n.VALUE)),
  sortable: true,
  truncateText: false,
  render: (values, data) => {
    const fieldFromBrowserField = getFieldFromBrowserField([data.category, 'fields', data.field], browserFields);
    return /*#__PURE__*/_react.default.createElement(_field_value_cell.FieldValueCell, {
      contextId: contextId,
      data: data,
      eventId: eventId,
      fieldFromBrowserField: fieldFromBrowserField,
      getLinkValue: getLinkValue,
      isDraggable: isDraggable,
      values: values
    });
  }
}];
exports.getColumns = getColumns;