"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RELEASING_LABEL = exports.ISOLATING_LABEL = exports.ISOLATED_LABEL = exports.EndpointAgentStatusById = exports.EndpointAgentStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../management/common/constants");
var _host_constants = require("../../../../management/pages/endpoint_hosts/view/host_constants");
var _empty_value = require("../../empty_value");
var _constants2 = require("../../../../../common/endpoint/service/response_actions/constants");
var _use_get_endpoint_pending_actions_summary = require("../../../../management/hooks/response_actions/use_get_endpoint_pending_actions_summary");
var _use_test_id_generator = require("../../../../management/hooks/use_test_id_generator");
var _hooks = require("../../../../management/hooks");
var _agent_status_text = require("../agent_status_text");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOOLTIP_CONTENT_STYLES = Object.freeze({
  width: 150
});
const ISOLATING_LABEL = exports.ISOLATING_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.agentAndActionsStatus.isIsolating', {
  defaultMessage: 'Isolating'
});
const RELEASING_LABEL = exports.RELEASING_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.agentAndActionsStatus.isUnIsolating', {
  defaultMessage: 'Releasing'
});
const ISOLATED_LABEL = exports.ISOLATED_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.agentAndActionsStatus.isolated', {
  defaultMessage: 'Isolated'
});
const EuiFlexGroupStyled = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  .isolation-status {
    margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
  }
`;
/**
 * Displays the status of an Endpoint agent along with its Isolation state or the number of pending
 * response actions against it.
 *
 * TIP: if you only have the Endpoint's `agent.id`, then consider using `EndpointAgentStatusById`,
 * which will call the needed APIs to get the information necessary to display the status.
 */
const EndpointAgentStatus = exports.EndpointAgentStatus = /*#__PURE__*/(0, _react.memo)(({
  endpointHostInfo,
  autoRefresh = true,
  pendingActions,
  'data-test-subj': dataTestSubj
}) => {
  var _endpointHostInfo$met;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    data: endpointPendingActions
  } = (0, _use_get_endpoint_pending_actions_summary.useGetEndpointPendingActionsSummary)([endpointHostInfo.metadata.agent.id], {
    refetchInterval: autoRefresh ? _constants.DEFAULT_POLL_INTERVAL : false,
    enabled: !pendingActions
  });
  const [hasPendingActions, hostPendingActions] = (0, _react.useMemo)(() => {
    var _endpointPendingActio;
    if (!endpointPendingActions && !pendingActions) {
      return [false, {}];
    }
    const pending = pendingActions ? pendingActions : (_endpointPendingActio = endpointPendingActions === null || endpointPendingActions === void 0 ? void 0 : endpointPendingActions.data[0].pending_actions) !== null && _endpointPendingActio !== void 0 ? _endpointPendingActio : {};
    return [Object.keys(pending).length > 0, pending];
  }, [endpointPendingActions, pendingActions]);
  const status = endpointHostInfo.host_status;
  const isIsolated = Boolean((_endpointHostInfo$met = endpointHostInfo.metadata.Endpoint.state) === null || _endpointHostInfo$met === void 0 ? void 0 : _endpointHostInfo$met.isolation);
  return /*#__PURE__*/_react.default.createElement(EuiFlexGroupStyled, {
    gutterSize: "none",
    responsive: false,
    className: "eui-textTruncate",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: status != null ? _host_constants.HOST_STATUS_TO_BADGE_COLOR[status] : 'warning',
    "data-test-subj": getTestId('agentStatus'),
    className: "eui-textTruncate"
  }, (0, _agent_status_text.getAgentStatusText)(status))), (isIsolated || hasPendingActions) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate isolation-status"
  }, /*#__PURE__*/_react.default.createElement(EndpointHostResponseActionsStatus, {
    "data-test-subj": getTestId('actionStatuses'),
    isIsolated: isIsolated,
    pendingActions: hostPendingActions
  })));
});
EndpointAgentStatus.displayName = 'EndpointAgentStatus';
/**
 * Given an Endpoint Agent Id, it will make the necessary API calls and then display the agent
 * status using the `<EndpointAgentStatus />` component.
 *
 * NOTE: if the `HostInfo` is already available, consider using `<EndpointAgentStatus/>` component
 * instead in order to avoid duplicate API calls.
 */
const EndpointAgentStatusById = exports.EndpointAgentStatusById = /*#__PURE__*/(0, _react.memo)(({
  endpointAgentId,
  autoRefresh,
  'data-test-subj': dataTestSubj
}) => {
  const {
    data
  } = (0, _hooks.useGetEndpointDetails)(endpointAgentId, {
    refetchInterval: autoRefresh ? _constants.DEFAULT_POLL_INTERVAL : false
  });
  const emptyValue = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement("p", null, (0, _empty_value.getEmptyValue)()));
  if (!data) {
    return emptyValue;
  }
  return /*#__PURE__*/_react.default.createElement(EndpointAgentStatus, {
    endpointHostInfo: data,
    "data-test-subj": dataTestSubj,
    autoRefresh: autoRefresh
  });
});
EndpointAgentStatusById.displayName = 'EndpointAgentStatusById';
const EndpointHostResponseActionsStatus = /*#__PURE__*/(0, _react.memo)(({
  pendingActions,
  isIsolated,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    totalPending,
    actionList,
    wasReleasing,
    wasIsolating,
    hasMultipleActionTypesPending,
    hasPendingIsolate,
    hasPendingUnIsolate
  } = (0, _react.useMemo)(() => {
    var _pendingActions$isola, _pendingActions$uniso;
    const list = [];
    let actionTotal = 0;
    let actionTypesCount = 0;
    Object.entries(pendingActions).sort().forEach(([actionName, actionCount]) => {
      var _RESPONSE_ACTION_API_;
      actionTotal += actionCount;
      actionTypesCount += 1;
      list.push({
        count: actionCount,
        label: (_RESPONSE_ACTION_API_ = _constants2.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP[actionName]) !== null && _RESPONSE_ACTION_API_ !== void 0 ? _RESPONSE_ACTION_API_ : actionName
      });
    });
    const pendingIsolate = (_pendingActions$isola = pendingActions.isolate) !== null && _pendingActions$isola !== void 0 ? _pendingActions$isola : 0;
    const pendingUnIsolate = (_pendingActions$uniso = pendingActions.unisolate) !== null && _pendingActions$uniso !== void 0 ? _pendingActions$uniso : 0;
    return {
      actionList: list,
      totalPending: actionTotal,
      wasReleasing: pendingIsolate === 0 && pendingUnIsolate > 0,
      wasIsolating: pendingIsolate > 0 && pendingUnIsolate === 0,
      hasMultipleActionTypesPending: actionTypesCount > 1,
      hasPendingIsolate: pendingIsolate > 0,
      hasPendingUnIsolate: pendingUnIsolate > 0
    };
  }, [pendingActions]);
  const badgeDisplayValue = (0, _react.useMemo)(() => {
    return hasPendingIsolate ? ISOLATING_LABEL : hasPendingUnIsolate ? RELEASING_LABEL : isIsolated ? ISOLATED_LABEL : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.agentAndActionsStatus.multiplePendingActions",
      defaultMessage: "{count} {count, plural, one {action} other {actions}} pending",
      values: {
        count: totalPending
      }
    });
  }, [hasPendingIsolate, hasPendingUnIsolate, isIsolated, totalPending]);
  const isolatedBadge = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      "data-test-subj": dataTestSubj
    }, ISOLATED_LABEL);
  }, [dataTestSubj]);

  // If nothing is pending
  if (totalPending === 0) {
    // and host is either releasing and or currently released, then render nothing
    if (!wasIsolating && wasReleasing || !isIsolated) {
      return null;
    }
    // else host was isolating or is isolated, then show isolation badge
    else if (!isIsolated && wasIsolating && !wasReleasing || isIsolated) {
      return isolatedBadge;
    }
  }

  // If there are different types of action pending
  //    --OR--
  // the only type of actions pending is NOT isolate/release,
  // then show a summary with tooltip
  if (hasMultipleActionTypesPending || !hasPendingIsolate && !hasPendingUnIsolate) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      "data-test-subj": dataTestSubj,
      iconType: "plus",
      iconSide: "right"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: "block",
      anchorClassName: "eui-textTruncate",
      anchorProps: {
        'data-test-subj': getTestId('tooltipTrigger')
      },
      content: /*#__PURE__*/_react.default.createElement("div", {
        style: TOOLTIP_CONTENT_STYLES,
        "data-test-subj": `${dataTestSubj}-tooltipContent`
      }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.agentAndActionsStatus.tooltipPendingActions",
        defaultMessage: "Pending actions:"
      })), actionList.map(({
        count,
        label
      }) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "none",
          key: label
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, label), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, count));
      }))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      "data-test-subj": `${dataTestSubj}-pending`
    }, badgeDisplayValue)));
  }

  // show pending isolation badge if a single type of isolation action has pending numbers.
  // We don't care about the count here because if there were more than 1 of the same type
  // (ex. 3 isolate... 0 release), then the action status displayed is still the same - "isolating".
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    "data-test-subj": getTestId('pending')
  }, badgeDisplayValue));
});
EndpointHostResponseActionsStatus.displayName = 'EndpointHostResponseActionsStatus';