"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_route_spy = require("../../../utils/route/use_route_spy");
var _kibana = require("../../../lib/kibana");
var _store = require("../../../../timelines/store");
var _constants = require("../../../../../common/constants");
var _panel_keys = require("../../../../flyout/document_details/shared/constants/panel_keys");
var _data_driven_columns = require("../../../../timelines/components/timeline/body/data_driven_columns");
var _types = require("../../../../../common/types");
var _use_experimental_features = require("../../../hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RowActionComponent = ({
  columnHeaders,
  controlColumn,
  data,
  disabled,
  index,
  isEventViewer,
  loadingEventIds,
  onRowSelected,
  onRuleChange,
  pageRowIndex,
  rowIndex,
  selectedEventIds,
  showCheckboxes,
  tabType,
  tableId,
  setEventsLoading,
  setEventsDeleted,
  width,
  refetch
}) => {
  const {
    data: timelineNonEcsData,
    ecs: ecsData,
    _id: eventId,
    _index: indexName
  } = data !== null && data !== void 0 ? data : {};
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const [isSecurityFlyoutEnabled] = (0, _public.useUiSetting$)(_constants.ENABLE_EXPANDABLE_FLYOUT_SETTING);
  const isExpandableFlyoutInCreateRuleEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('expandableFlyoutInCreateRuleEnabled');
  const columnValues = (0, _react.useMemo)(() => timelineNonEcsData && columnHeaders.map(header => {
    var _getMappedNonEcsValue;
    return (_getMappedNonEcsValue = (0, _data_driven_columns.getMappedNonEcsValue)({
      data: timelineNonEcsData,
      fieldName: header.id
    })) !== null && _getMappedNonEcsValue !== void 0 ? _getMappedNonEcsValue : [];
  }).join(' '), [columnHeaders, timelineNonEcsData]);
  let showExpandableFlyout;

  // disable the old flyout on attack discovery page
  if (pageName === _constants.SecurityPageName.attackDiscovery) {
    showExpandableFlyout = true;
  } else if (tableId === _securitysolutionDataTable.TableId.rulePreview) {
    showExpandableFlyout = isSecurityFlyoutEnabled && isExpandableFlyoutInCreateRuleEnabled;
  } else {
    showExpandableFlyout = isSecurityFlyoutEnabled;
  }
  const handleOnEventDetailPanelOpened = (0, _react.useCallback)(() => {
    const updatedExpandedDetail = {
      panelView: 'eventDetail',
      params: {
        eventId: eventId !== null && eventId !== void 0 ? eventId : '',
        indexName: indexName !== null && indexName !== void 0 ? indexName : ''
      }
    };
    if (showExpandableFlyout) {
      openFlyout({
        right: {
          id: _panel_keys.DocumentDetailsRightPanelKey,
          params: {
            id: eventId,
            indexName,
            scopeId: tableId
          }
        }
      });
      telemetry.reportDetailsFlyoutOpened({
        location: tableId,
        panel: 'right'
      });
    }
    // TODO remove when https://github.com/elastic/security-team/issues/7462 is merged
    // support of old flyout in cases page
    else if (tableId === _securitysolutionDataTable.TableId.alertsOnCasePage) {
      dispatch(_store.timelineActions.toggleDetailPanel({
        ...updatedExpandedDetail,
        id: _types.TimelineId.casePage
      }));
    }
    // TODO remove when https://github.com/elastic/security-team/issues/7462 is merged
    // support of old flyout
    else {
      dispatch(_securitysolutionDataTable.dataTableActions.toggleDetailPanel({
        ...updatedExpandedDetail,
        tabType,
        id: tableId
      }));
    }
  }, [dispatch, eventId, indexName, openFlyout, tabType, tableId, showExpandableFlyout, telemetry]);
  const Action = controlColumn.rowCellRender;
  if (!timelineNonEcsData || !ecsData || !eventId) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "noData"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Action && /*#__PURE__*/_react.default.createElement(Action, {
    ariaRowindex: pageRowIndex + 1,
    checked: Object.keys(selectedEventIds).includes(eventId),
    columnId: controlColumn.id || '',
    columnValues: columnValues || '',
    data: timelineNonEcsData,
    "data-test-subj": "actions",
    disabled: disabled,
    ecsData: ecsData,
    eventId: eventId,
    index: index,
    isEventViewer: isEventViewer,
    loadingEventIds: loadingEventIds,
    onEventDetailsPanelOpened: handleOnEventDetailPanelOpened,
    onRowSelected: onRowSelected,
    onRuleChange: onRuleChange,
    rowIndex: rowIndex,
    showCheckboxes: showCheckboxes,
    tabType: tabType,
    timelineId: tableId,
    width: width,
    setEventsLoading: setEventsLoading,
    setEventsDeleted: setEventsDeleted,
    refetch: refetch
  }));
};
const RowAction = exports.RowAction = /*#__PURE__*/_react.default.memo(RowActionComponent);