"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRequestBody = exports.getGenAiConfig = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// aligns with OpenAiProviderType from '@kbn/stack-connectors-plugin/common/openai/types'
var OpenAiProviderType = /*#__PURE__*/function (OpenAiProviderType) {
  OpenAiProviderType["OpenAi"] = "OpenAI";
  OpenAiProviderType["AzureAi"] = "Azure OpenAI";
  return OpenAiProviderType;
}(OpenAiProviderType || {});
/**
 * Returns the GenAiConfig for a given ActionConnector. Note that if the connector is preconfigured,
 * the config will be undefined as the connector is neither available nor editable.
 *
 * @param connector
 */
const getGenAiConfig = connector => {
  if (!(connector !== null && connector !== void 0 && connector.isPreconfigured)) {
    const config = connector === null || connector === void 0 ? void 0 : connector.config;
    const {
      apiProvider,
      apiUrl,
      defaultModel
    } = config !== null && config !== void 0 ? config : {};
    return {
      apiProvider,
      apiUrl,
      defaultModel: apiProvider === OpenAiProviderType.AzureAi ? getAzureApiVersionParameter(apiUrl !== null && apiUrl !== void 0 ? apiUrl : '') : defaultModel
    };
  }
  return undefined; // the connector is neither available nor editable
};
exports.getGenAiConfig = getGenAiConfig;
const getAzureApiVersionParameter = url => {
  var _urlSearchParams$get;
  const urlSearchParams = new URLSearchParams(new URL(url).search);
  return (_urlSearchParams$get = urlSearchParams.get('api-version')) !== null && _urlSearchParams$get !== void 0 ? _urlSearchParams$get : undefined;
};
const getRequestBody = ({
  actionTypeId,
  alertsIndexPattern,
  anonymizationFields,
  connectorId,
  knowledgeBase,
  traceOptions
}) => {
  var _anonymizationFields$;
  return {
    actionTypeId,
    alertsIndexPattern: alertsIndexPattern !== null && alertsIndexPattern !== void 0 ? alertsIndexPattern : '',
    anonymizationFields: (_anonymizationFields$ = anonymizationFields === null || anonymizationFields === void 0 ? void 0 : anonymizationFields.data) !== null && _anonymizationFields$ !== void 0 ? _anonymizationFields$ : [],
    connectorId: connectorId !== null && connectorId !== void 0 ? connectorId : '',
    langSmithProject: (0, _fp.isEmpty)(traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.langSmithProject) ? undefined : traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.langSmithProject,
    langSmithApiKey: (0, _fp.isEmpty)(traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.langSmithApiKey) ? undefined : traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.langSmithApiKey,
    size: knowledgeBase.latestAlerts,
    replacements: {},
    // no need to re-use replacements in the current implementation
    subAction: 'invokeAI' // non-streaming
  };
};
exports.getRequestBody = getRequestBody;