"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryTour = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_route_spy = require("../../common/utils/route/use_route_spy");
var _video_toast = require("./video_toast");
var _use_is_element_mounted = require("../../detection_engine/rule_management_ui/components/rules_table/rules_table/guided_onboarding/use_is_element_mounted");
var _constants = require("../../../common/constants");
var _kibana = require("../../common/lib/kibana");
var _step_config = require("./step_config");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * The attack discovery tour for 8.14
 *
 * */

const AttackDiscoveryTourComp = () => {
  var _storage$get;
  const {
    services: {
      storage
    }
  } = (0, _kibana.useKibana)();
  const {
    navigateTo
  } = (0, _kibana.useNavigation)();
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const [tourState, setTourState] = (0, _react.useState)((_storage$get = storage.get(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.ATTACK_DISCOVERY)) !== null && _storage$get !== void 0 ? _storage$get : _step_config.tourConfig);
  const advanceToVideoStep = (0, _react.useCallback)(() => {
    setTourState(prev => {
      storage.set(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.ATTACK_DISCOVERY, {
        ...prev,
        currentTourStep: 2
      });
      return {
        ...prev,
        currentTourStep: 2
      };
    });
  }, [storage]);
  (0, _react.useEffect)(() => {
    if (tourState.isTourActive && pageName === _constants.SecurityPageName.attackDiscovery) {
      advanceToVideoStep();
    }
  }, [advanceToVideoStep, pageName, tourState.isTourActive]);
  const finishTour = (0, _react.useCallback)(() => {
    setTourState(prev => {
      storage.set(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.ATTACK_DISCOVERY, {
        ...prev,
        isTourActive: false
      });
      return {
        ...prev,
        isTourActive: false
      };
    });
  }, [storage]);
  const navigateToAttackDiscovery = (0, _react.useCallback)(() => {
    navigateTo({
      deepLinkId: _constants.SecurityPageName.attackDiscovery
    });
  }, [navigateTo]);
  const nextStep = (0, _react.useCallback)(() => {
    if (tourState.currentTourStep === 1) {
      navigateToAttackDiscovery();
      advanceToVideoStep();
    }
  }, [tourState.currentTourStep, navigateToAttackDiscovery, advanceToVideoStep]);
  const footerAction = (0, _react.useMemo)(() => [
  /*#__PURE__*/
  // if exit, set tour to the video step without navigating to the page
  _react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    onClick: advanceToVideoStep
  }, i18n.ATTACK_DISCOVERY_TOUR_EXIT),
  /*#__PURE__*/
  // if next, set tour to the video step and navigate to the page
  _react.default.createElement(_eui.EuiButton, {
    color: "success",
    size: "s",
    onClick: nextStep
  }, i18n.ATTACK_DISCOVERY_TRY_IT)], [advanceToVideoStep, nextStep]);
  const isElementAtCurrentStepMounted = (0, _use_is_element_mounted.useIsElementMounted)(_step_config.attackDiscoveryTourStepOne === null || _step_config.attackDiscoveryTourStepOne === void 0 ? void 0 : _step_config.attackDiscoveryTourStepOne.anchor);
  const isTestAutomation = window.Cypress != null ||
  // TODO: temporary workaround to disable the tour when running in Cypress, because the tour breaks other projects Cypress tests
  navigator.webdriver === true; // TODO: temporary workaround to disable the tour when running in the FTR, because the tour breaks other projects FTR tests

  if (isTestAutomation || !tourState.isTourActive || tourState.currentTourStep === 1 && !isElementAtCurrentStepMounted) {
    return null;
  }
  return tourState.currentTourStep === 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    anchor: `#${_step_config.attackDiscoveryTourStepOne.anchor}`,
    content: _step_config.attackDiscoveryTourStepOne.content,
    footerAction: footerAction,
    isStepOpen: true,
    maxWidth: 450,
    onFinish: advanceToVideoStep,
    panelProps: {
      'data-test-subj': `attackDiscovery-tour-step-1`
    },
    repositionOnScroll: true,
    step: 1,
    stepsTotal: 1,
    title: _step_config.attackDiscoveryTourStepOne.title
  }) : pageName === _constants.SecurityPageName.attackDiscovery ? /*#__PURE__*/_react.default.createElement(_video_toast.VideoToast, {
    onClose: finishTour
  }) : null;
};
const AttackDiscoveryTour = exports.AttackDiscoveryTour = /*#__PURE__*/_react.default.memo(AttackDiscoveryTourComp);