"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setSessionStorageCachedAttackDiscoveries = exports.setLocalStorageGenerationIntervals = exports.getSessionStorageCachedAttackDiscoveries = exports.getLocalStorageGenerationIntervals = exports.encodeGenerationIntervals = exports.encodeCachedAttackDiscoveries = exports.decodeGenerationIntervals = exports.decodeCachedAttackDiscoveries = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const encodeCachedAttackDiscoveries = cachedAttackDiscoveries => {
  try {
    return JSON.stringify(cachedAttackDiscoveries);
  } catch {
    return null;
  }
};
exports.encodeCachedAttackDiscoveries = encodeCachedAttackDiscoveries;
const decodeCachedAttackDiscoveries = cachedAttackDiscoveries => {
  try {
    return JSON.parse(cachedAttackDiscoveries);
  } catch {
    return null;
  }
};
exports.decodeCachedAttackDiscoveries = decodeCachedAttackDiscoveries;
const getSessionStorageCachedAttackDiscoveries = key => {
  if (!(0, _fp.isEmpty)(key)) {
    var _sessionStorage$getIt;
    return decodeCachedAttackDiscoveries((_sessionStorage$getIt = sessionStorage.getItem(key)) !== null && _sessionStorage$getIt !== void 0 ? _sessionStorage$getIt : '');
  }
  return null;
};
exports.getSessionStorageCachedAttackDiscoveries = getSessionStorageCachedAttackDiscoveries;
const setSessionStorageCachedAttackDiscoveries = ({
  key,
  cachedAttackDiscoveries
}) => {
  if (!(0, _fp.isEmpty)(key)) {
    const encoded = encodeCachedAttackDiscoveries(cachedAttackDiscoveries);
    if (encoded != null) {
      sessionStorage.setItem(key, encoded);
    }
  }
};
exports.setSessionStorageCachedAttackDiscoveries = setSessionStorageCachedAttackDiscoveries;
const encodeGenerationIntervals = generationIntervals => {
  try {
    return JSON.stringify(generationIntervals);
  } catch {
    return null;
  }
};
exports.encodeGenerationIntervals = encodeGenerationIntervals;
const decodeGenerationIntervals = generationIntervals => {
  const parseDate = (key, value) => {
    if (key === 'date' && typeof value === 'string') {
      return new Date(value);
    } else if (key === 'date' && typeof value !== 'string') {
      throw new Error('Invalid date');
    } else {
      return value;
    }
  };
  try {
    return JSON.parse(generationIntervals, parseDate);
  } catch {
    return null;
  }
};
exports.decodeGenerationIntervals = decodeGenerationIntervals;
const getLocalStorageGenerationIntervals = key => {
  if (!(0, _fp.isEmpty)(key)) {
    var _localStorage$getItem;
    return decodeGenerationIntervals((_localStorage$getItem = localStorage.getItem(key)) !== null && _localStorage$getItem !== void 0 ? _localStorage$getItem : '');
  }
  return null;
};
exports.getLocalStorageGenerationIntervals = getLocalStorageGenerationIntervals;
const setLocalStorageGenerationIntervals = ({
  key,
  generationIntervals
}) => {
  if (!(0, _fp.isEmpty)(key)) {
    const encoded = encodeGenerationIntervals(generationIntervals);
    if (encoded != null) {
      localStorage.setItem(key, encoded);
    }
  }
};
exports.setLocalStorageGenerationIntervals = setLocalStorageGenerationIntervals;