"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _fp = require("lodash/fp");
var _react2 = _interopRequireDefault(require("react"));
var _use_assistant_availability = require("../../../assistant/use_assistant_availability");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderComponent = ({
  connectorId,
  connectorsAreConfigured,
  isLoading,
  onGenerate,
  onConnectorIdSelected
}) => {
  const isFlyoutMode = false; // always false for attack discovery
  const {
    hasAssistantPrivilege
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const disabled = !hasAssistantPrivilege || isLoading || connectorId == null;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
        gap: ${euiTheme.size.m};
        margin-top: ${euiTheme.size.m};
      `,
    "data-test-subj": "header",
    gutterSize: "none"
  }, connectorsAreConfigured && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_elasticAssistant.ConnectorSelectorInline, {
    isFlyoutMode: isFlyoutMode,
    onConnectorSelected: _fp.noop,
    onConnectorIdSelected: onConnectorIdSelected,
    selectedConnectorId: connectorId
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: connectorId == null ? i18n.SELECT_A_CONNECTOR : null,
    "data-test-subj": "generateTooltip"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "generate",
    size: "s",
    disabled: disabled,
    isLoading: isLoading,
    onClick: onGenerate
  }, isLoading ? i18n.LOADING : i18n.GENERATE))));
};
HeaderComponent.displayName = 'Header';
const Header = exports.Header = /*#__PURE__*/_react2.default.memo(HeaderComponent);