"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyStates = void 0;
var _react = _interopRequireDefault(require("react"));
var _empty_prompt = require("../empty_prompt");
var _helpers = require("../helpers");
var _no_alerts = require("../no_alerts");
var _welcome = require("../welcome");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyStatesComponent = ({
  aiConnectorsCount,
  alertsContextCount,
  alertsCount,
  attackDiscoveriesCount,
  connectorId,
  isLoading,
  onGenerate
}) => {
  if ((0, _helpers.showWelcomePrompt)({
    aiConnectorsCount,
    isLoading
  })) {
    return /*#__PURE__*/_react.default.createElement(_welcome.Welcome, null);
  } else if ((0, _helpers.showNoAlertsPrompt)({
    alertsContextCount,
    isLoading
  })) {
    return /*#__PURE__*/_react.default.createElement(_no_alerts.NoAlerts, null);
  } else if ((0, _helpers.showEmptyPrompt)({
    attackDiscoveriesCount,
    isLoading
  })) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      alertsCount: alertsCount,
      isDisabled: connectorId == null,
      isLoading: isLoading,
      onGenerate: onGenerate
    });
  }
  return null;
};
EmptyStatesComponent.displayName = 'EmptyStates';
const EmptyStates = exports.EmptyStates = /*#__PURE__*/_react.default.memo(EmptyStatesComponent);