"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPrompt = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _use_assistant_availability = require("../../../assistant/use_assistant_availability");
var _animated_counter = require("./animated_counter");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyPromptComponent = ({
  alertsCount,
  isLoading,
  isDisabled = false,
  onGenerate
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    hasAssistantPrivilege
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const title = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "emptyPromptTitleContainer",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "emptyPromptAvatar",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_elasticAssistant.AssistantAvatar, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "row",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
                margin-right: ${euiTheme.size.xs};
              `,
    "data-test-subj": "upTo",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.UP_TO)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "emptyPromptAnimatedCounter",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_animated_counter.AnimatedCounter, {
    count: alertsCount
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "emptyPromptAlertsWillBeAnalyzed",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.ALERTS_WILL_BE_ANALYZED(alertsCount))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
                margin-left: ${euiTheme.size.xs};
              `,
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
    content: i18n.RESPONSES_FROM_AI_SYSTEMS,
    "data-test-subj": "responsesFromAiSystemsTooltip",
    position: "right",
    type: "iInCircle"
  }))))), [alertsCount, euiTheme.size.xs]);
  const body = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "bodyContainer",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "startGeneratingDiscoveriesLabel"
  }, i18n.START_GENERATING_DISCOVERIES))), []);
  const actions = (0, _react2.useMemo)(() => {
    const disabled = !hasAssistantPrivilege || isLoading || isDisabled;
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
      content: disabled ? i18n.SELECT_A_CONNECTOR : null,
      "data-test-subj": "generateTooltip"
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      color: "primary",
      "data-test-subj": "generate",
      disabled: disabled,
      onClick: onGenerate
    }, i18n.GENERATE));
  }, [hasAssistantPrivilege, isDisabled, isLoading, onGenerate]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "emptyPrompt",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "emptyPromptContainer",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    actions: actions,
    body: body,
    title: title
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    "data-test-subj": "learnMore",
    href: "https://www.elastic.co/guide/en/security/current/attack-discovery.html",
    target: "_blank"
  }, i18n.LEARN_MORE)));
};
const EmptyPrompt = exports.EmptyPrompt = /*#__PURE__*/_react2.default.memo(EmptyPromptComponent);