"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMarkdownWithOriginalValues = exports.getMarkdownFields = exports.getAttackDiscoveryMarkdown = exports.getAttackChainMarkdown = void 0;
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMarkdownFields = markdown => {
  const regex = new RegExp('{{\\s*(\\S+)\\s+(\\S+)\\s*}}', 'gm');
  return markdown.replace(regex, (_, field, value) => `\`${value}\``);
};
exports.getMarkdownFields = getMarkdownFields;
const getAttackChainMarkdown = attackDiscovery => {
  const tacticMetadata = (0, _helpers.getTacticMetadata)(attackDiscovery).filter(tactic => tactic.detected);
  if (tacticMetadata.length === 0) {
    return '';
  }
  const markdownList = tacticMetadata.map(tactic => `- ${(0, _helpers.getTacticLabel)(tactic.name)}`).join('\n');
  return `### Attack Chain
${markdownList}
`;
};
exports.getAttackChainMarkdown = getAttackChainMarkdown;
const getMarkdownWithOriginalValues = ({
  markdown,
  replacements
}) => {
  if (replacements == null) {
    return markdown;
  }
  return Object.keys(replacements).reduce((acc, uuid) => acc.replaceAll(uuid, replacements[uuid]), markdown);
};
exports.getMarkdownWithOriginalValues = getMarkdownWithOriginalValues;
const getAttackDiscoveryMarkdown = ({
  attackDiscovery,
  replacements
}) => {
  const title = getMarkdownFields(attackDiscovery.title);
  const entitySummaryMarkdown = getMarkdownFields(attackDiscovery.entitySummaryMarkdown);
  const summaryMarkdown = getMarkdownFields(attackDiscovery.summaryMarkdown);
  const detailsMarkdown = getMarkdownFields(attackDiscovery.detailsMarkdown);
  const markdown = `## ${title}

${entitySummaryMarkdown}

### Summary
${summaryMarkdown}

### Details
${detailsMarkdown}

${getAttackChainMarkdown(attackDiscovery)}
`;
  if (replacements != null) {
    return getMarkdownWithOriginalValues({
      markdown,
      replacements
    });
  } else {
    return markdown;
  }
};
exports.getAttackDiscoveryMarkdown = getAttackDiscoveryMarkdown;