"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useViewInAiAssistant = void 0;
var _react = require("react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _use_assistant_availability = require("../../../assistant/use_assistant_availability");
var _get_attack_discovery_markdown = require("../../get_attack_discovery_markdown/get_attack_discovery_markdown");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This category is provided in the prompt context for the assistant
 */
const category = 'insight';
const useViewInAiAssistant = ({
  attackDiscovery,
  replacements
}) => {
  const {
    hasAssistantPrivilege,
    isAssistantEnabled
  } = (0, _use_assistant_availability.useAssistantAvailability)();

  // the prompt context for this insight:
  const getPromptContext = (0, _react.useCallback)(async () => (0, _get_attack_discovery_markdown.getAttackDiscoveryMarkdown)({
    attackDiscovery
    // note: we do NOT want to replace the replacements here
  }), [attackDiscovery]);
  const {
    promptContextId,
    showAssistantOverlay: showOverlay
  } = (0, _elasticAssistant.useAssistantOverlay)(category, attackDiscovery.title,
  // conversation title
  attackDiscovery.title,
  // description used in context pill
  getPromptContext, attackDiscovery.id,
  // accept the UUID default for this prompt context
  null,
  // suggestedUserPrompt
  null,
  // tooltip
  isAssistantEnabled, replacements !== null && replacements !== void 0 ? replacements : null);

  // proxy show / hide calls to assistant context, using our internal prompt context id:
  const showAssistantOverlay = (0, _react.useCallback)(() => {
    showOverlay(true, true);
  }, [showOverlay]);
  const disabled = !hasAssistantPrivilege || promptContextId == null;
  return (0, _react.useMemo)(() => ({
    promptContextId,
    disabled,
    showAssistantOverlay
  }), [promptContextId, disabled, showAssistantOverlay]);
};
exports.useViewInAiAssistant = useViewInAiAssistant;