"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Title = void 0;
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AVATAR_SIZE = 24; // px

const TitleComponent = ({
  isLoading,
  title
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "title",
    gutterSize: "s"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
          background-color: ${euiTheme.colors.lightestShade};
          border-radius: 50%;
          height: ${AVATAR_SIZE}px;
          width: ${AVATAR_SIZE}px;
          overflow: hidden;
        `,
    "data-test-subj": "assistantAvatar",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_elasticAssistant.AssistantAvatar, {
    css: (0, _react.css)`
            transform: translate(5px, 5px);
          `,
    size: "xxs"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, isLoading ? /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonTitle, {
    css: (0, _react.css)`
              inline-size: 100%;
            `,
    "data-test-subj": "skeletonTitle",
    size: "xs"
  }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "titleText",
    size: "xs"
  }, /*#__PURE__*/_react2.default.createElement("h2", null, title))));
};
TitleComponent.displayName = 'Title';
const Title = exports.Title = /*#__PURE__*/_react2.default.memo(TitleComponent);