"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tactic = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _axis_tick = require("../axis_tick");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INNER_CIRCLE_LEFT_JUSTIFY_X_OFFSET = 0; // px
const INNER_CIRCLE_RIGHT_JUSTIFY_X_OFFSET = 232; // px

const OUTER_CIRCLE_LEFT_JUSTIFY_X_OFFSET = -4; // px
const OUTER_CIRCLE_RIGHT_JUSTIFY_X_OFFSET = 228; // px

const TacticComponent = ({
  detected,
  rightJustify = false,
  tactic
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const WIDTH = 120; // px
  const TICK_COUNT = 10;
  const ticks = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    "data-tests-subj": "ticks",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
            overflow: hidden;
            width: ${WIDTH}px;
          `
  }), Array.from({
    length: TICK_COUNT
  }).map((_, i) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    key: i,
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_axis_tick.AxisTick, null)))), []);
  const color = detected ? euiTheme.colors.danger : euiTheme.colors.subduedText;
  const innerCircleXOffset = rightJustify ? INNER_CIRCLE_RIGHT_JUSTIFY_X_OFFSET : INNER_CIRCLE_LEFT_JUSTIFY_X_OFFSET;
  const outerCircleXOffset = rightJustify ? OUTER_CIRCLE_RIGHT_JUSTIFY_X_OFFSET : OUTER_CIRCLE_LEFT_JUSTIFY_X_OFFSET;
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        width: ${WIDTH}px;
      `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: rightJustify ? 'flexEnd' : undefined,
    "data-test-subj": "tactic",
    direction: "column",
    gutterSize: "none",
    wrap: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            position: relative;
          `,
    "data-test-subj": "tics",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
              background: transparent;
              border: 2px solid ${color};
              border-radius: 50%;
              height: 8px;
              position: absolute;
              transform: translate(${innerCircleXOffset}px, -2px);
              width: 8px;
            `,
    "data-test-subj": "innerCircle"
  }), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
              background: transparent;
              border: 2px solid ${color};
              border-radius: 50%;
              height: 16px;
              opacity: ${detected ? 25 : 0}%;
              position: absolute;
              transform: translate(${outerCircleXOffset}px, -6px);
              width: 16px;
            `,
    "data-test-subj": "outerCircle"
  }), /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, ticks)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            position: relative;
          `,
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            position: relative;
          `,
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: color,
    "data-test-subj": "tacticText",
    size: "xs"
  }, tactic))));
};
TacticComponent.displayName = 'Tactic';
const Tactic = exports.Tactic = /*#__PURE__*/_react2.default.memo(TacticComponent);