"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBaseConversations = void 0;
var _fp = require("lodash/fp");
var _translations = require("@kbn/ecs-data-quality-dashboard/impl/data_quality/data_quality_panel/tabs/summary_tab/callout_summary/translations");
var _react = require("react");
var _conversations = require("../content/conversations");
var _links = require("../../common/links");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBaseConversations = () => {
  const isDataQualityDashboardPageExists = (0, _links.useLinkAuthorized)(_common.SecurityPageName.dataQuality);
  const baseConversations = (0, _react.useMemo)(() => isDataQualityDashboardPageExists ? _conversations.BASE_SECURITY_CONVERSATIONS : (0, _fp.unset)(_translations.DATA_QUALITY_DASHBOARD_CONVERSATION_ID, _conversations.BASE_SECURITY_CONVERSATIONS), [isDataQualityDashboardPageExists]);
  return baseConversations;
};
exports.useBaseConversations = useBaseConversations;