"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssistantTelemetry = void 0;
var _react = require("react");
var _kibana = require("../../common/lib/kibana");
var _use_conversation_store = require("../use_conversation_store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAssistantTelemetry = () => {
  const {
    services: {
      telemetry
    }
  } = (0, _kibana.useKibana)();
  const baseConversations = (0, _use_conversation_store.useBaseConversations)();
  const getAnonymizedConversationTitle = (0, _react.useCallback)(async title => {
    // With persistent storage for conversation replacing id to title, because id is UUID now
    // and doesn't make any value for telemetry tracking
    return baseConversations[title] ? title : 'Custom';
  }, [baseConversations]);
  const reportTelemetry = (0, _react.useCallback)(async ({
    fn,
    params: {
      conversationId,
      ...rest
    }
  }) => fn({
    ...rest,
    conversationId: await getAnonymizedConversationTitle(conversationId)
  }), [getAnonymizedConversationTitle]);
  return {
    reportAssistantInvoked: params => reportTelemetry({
      fn: telemetry.reportAssistantInvoked,
      params
    }),
    reportAssistantMessageSent: params => reportTelemetry({
      fn: telemetry.reportAssistantMessageSent,
      params
    }),
    reportAssistantQuickPrompt: params => reportTelemetry({
      fn: telemetry.reportAssistantQuickPrompt,
      params
    }),
    reportAssistantSettingToggled: params => telemetry.reportAssistantSettingToggled(params)
  };
};
exports.useAssistantTelemetry = useAssistantTelemetry;