"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssistantAvailability = void 0;
var _use_license = require("../../common/hooks/use_license");
var _kibana = require("../../common/lib/kibana");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAssistantAvailability = () => {
  var _capabilities$ASSISTA, _capabilities$ASSISTA2, _capabilities$actions, _capabilities$actions2, _capabilities$actions3, _capabilities$actions4;
  const isEnterprise = (0, _use_license.useLicense)().isEnterprise();
  const capabilities = (0, _kibana.useKibana)().services.application.capabilities;
  const hasAssistantPrivilege = ((_capabilities$ASSISTA = capabilities[_constants.ASSISTANT_FEATURE_ID]) === null || _capabilities$ASSISTA === void 0 ? void 0 : _capabilities$ASSISTA['ai-assistant']) === true;
  const hasUpdateAIAssistantAnonymization = ((_capabilities$ASSISTA2 = capabilities[_constants.ASSISTANT_FEATURE_ID]) === null || _capabilities$ASSISTA2 === void 0 ? void 0 : _capabilities$ASSISTA2.updateAIAssistantAnonymization) === true;

  // Connectors & Actions capabilities as defined in x-pack/plugins/actions/server/feature.ts
  // `READ` ui capabilities defined as: { ui: ['show', 'execute'] }
  const hasConnectorsReadPrivilege = ((_capabilities$actions = capabilities.actions) === null || _capabilities$actions === void 0 ? void 0 : _capabilities$actions.show) === true && ((_capabilities$actions2 = capabilities.actions) === null || _capabilities$actions2 === void 0 ? void 0 : _capabilities$actions2.execute) === true;
  // `ALL` ui capabilities defined as: { ui: ['show', 'execute', 'save', 'delete'] }
  const hasConnectorsAllPrivilege = hasConnectorsReadPrivilege && ((_capabilities$actions3 = capabilities.actions) === null || _capabilities$actions3 === void 0 ? void 0 : _capabilities$actions3.delete) === true && ((_capabilities$actions4 = capabilities.actions) === null || _capabilities$actions4 === void 0 ? void 0 : _capabilities$actions4.save) === true;
  return {
    hasAssistantPrivilege,
    hasConnectorsAllPrivilege,
    hasConnectorsReadPrivilege,
    isAssistantEnabled: isEnterprise,
    hasUpdateAIAssistantAnonymization
  };
};
exports.useAssistantAvailability = useAssistantAvailability;