"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConversations = exports.AssistantProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _datemath = require("@kbn/datemath");
var _i18n = require("@kbn/i18n");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _fp = require("lodash/fp");
var _constants = require("@kbn/triggers-actions-ui-plugin/public/common/constants");
var _common = require("../../common");
var _kibana = require("../common/lib/kibana");
var _use_assistant_telemetry = require("./use_assistant_telemetry");
var _get_comments = require("./get_comments");
var _helpers = require("./helpers");
var _use_conversation_store = require("./use_conversation_store");
var _prompt_contexts = require("./content/prompt_contexts");
var _quick_prompts = require("./content/quick_prompts");
var _system = require("./content/prompts/system");
var _use_assistant_availability = require("./use_assistant_availability");
var _use_app_toasts = require("../common/hooks/use_app_toasts");
var _use_signal_index = require("../detections/containers/detection_engine/alerts/use_signal_index");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSISTANT_TITLE = _i18n.i18n.translate('xpack.securitySolution.assistant.title', {
  defaultMessage: 'Elastic AI Assistant'
});
const LOCAL_CONVERSATIONS_MIGRATION_STATUS_TOAST_TITLE = _i18n.i18n.translate('xpack.securitySolution.assistant.conversationMigrationStatus.title', {
  defaultMessage: 'Local storage conversations persisted successfuly.'
});
const createConversations = async (notifications, http, storage) => {
  // migrate conversations with messages from the local storage
  // won't happen next time
  const conversations = storage.get(`${_common.APP_ID}.${_helpers.LOCAL_STORAGE_KEY}`);
  if (conversations && Object.keys(conversations).length > 0) {
    const conversationsToCreate = Object.values(conversations).filter(
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    c => c.messages && c.messages.length > 0);
    const transformMessage = m => {
      var _parse, _m$timestamp;
      const timestamp = (_parse = (0, _datemath.parse)((_m$timestamp = m.timestamp) !== null && _m$timestamp !== void 0 ? _m$timestamp : '')) === null || _parse === void 0 ? void 0 : _parse.toISOString();
      return {
        ...m,
        timestamp: timestamp == null ? new Date().toISOString() : timestamp
      };
    };
    const connectors = await (0, _constants.loadAllActions)({
      http
    });

    // post bulk create
    const bulkResult = await (0, _elasticAssistant.bulkUpdateConversations)(http, {
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      create: conversationsToCreate.reduce((res, c) => {
        var _c$messages;
        // ensure actionTypeId is added to apiConfig from legacy conversation data
        if (c.apiConfig && !c.apiConfig.actionTypeId) {
          const selectedConnector = (connectors !== null && connectors !== void 0 ? connectors : []).find(connector => connector.id === c.apiConfig.connectorId);
          if (selectedConnector) {
            c.apiConfig = {
              ...c.apiConfig,
              actionTypeId: selectedConnector.actionTypeId
            };
          } else {
            c.apiConfig = undefined;
          }
        }
        res[c.id] = {
          ...c,
          messages: ((_c$messages = c.messages) !== null && _c$messages !== void 0 ? _c$messages : []).map(transformMessage),
          title: c.id,
          replacements: c.replacements
        };
        return res;
      }, {})
    }, notifications.toasts);
    if (bulkResult && bulkResult.success) {
      var _notifications$toasts;
      storage.remove(`${_common.APP_ID}.${_helpers.LOCAL_STORAGE_KEY}`);
      (_notifications$toasts = notifications.toasts) === null || _notifications$toasts === void 0 ? void 0 : _notifications$toasts.addSuccess({
        iconType: 'check',
        title: LOCAL_CONVERSATIONS_MIGRATION_STATUS_TOAST_TITLE
      });
      return true;
    }
    return false;
  }
};

/**
 * This component configures the Elastic AI Assistant context provider for the Security Solution app.
 */
exports.createConversations = createConversations;
const AssistantProvider = ({
  children
}) => {
  const {
    http,
    notifications,
    storage,
    triggersActionsUi: {
      actionTypeRegistry
    },
    docLinks: {
      ELASTIC_WEBSITE_URL,
      DOC_LINK_VERSION
    }
  } = (0, _kibana.useKibana)().services;
  const basePath = (0, _kibana.useBasePath)();
  const baseConversations = (0, _use_conversation_store.useBaseConversations)();
  const assistantAvailability = (0, _use_assistant_availability.useAssistantAvailability)();
  const assistantTelemetry = (0, _use_assistant_telemetry.useAssistantTelemetry)();
  (0, _react.useEffect)(() => {
    const migrateConversationsFromLocalStorage = (0, _fp.once)(async () => {
      const res = await (0, _elasticAssistant.getUserConversations)({
        http
      });
      if (assistantAvailability.isAssistantEnabled && assistantAvailability.hasAssistantPrivilege && res.total === 0) {
        await createConversations(notifications, http, storage);
      }
    });
    migrateConversationsFromLocalStorage();
  }, [assistantAvailability.hasAssistantPrivilege, assistantAvailability.isAssistantEnabled, http, notifications, storage]);
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const alertsIndexPattern = signalIndexName !== null && signalIndexName !== void 0 ? signalIndexName : undefined;
  const toasts = (0, _use_app_toasts.useAppToasts)(); // useAppToasts is the current, non-deprecated method of getting the toasts service in the Security Solution, but it doesn't return the IToasts interface (defined by core)

  return /*#__PURE__*/_react.default.createElement(_elasticAssistant.AssistantProvider, {
    actionTypeRegistry: actionTypeRegistry,
    alertsIndexPattern: alertsIndexPattern,
    augmentMessageCodeBlocks: _helpers.augmentMessageCodeBlocks,
    assistantAvailability: assistantAvailability,
    assistantTelemetry: assistantTelemetry,
    docLinks: {
      ELASTIC_WEBSITE_URL,
      DOC_LINK_VERSION
    },
    basePath: basePath,
    basePromptContexts: Object.values(_prompt_contexts.PROMPT_CONTEXTS),
    baseQuickPrompts: _quick_prompts.BASE_SECURITY_QUICK_PROMPTS // to server and plugin start
    ,
    baseSystemPrompts: _system.BASE_SECURITY_SYSTEM_PROMPTS // to server and plugin start
    ,
    baseConversations: baseConversations,
    getComments: _get_comments.getComments,
    http: http,
    title: ASSISTANT_TITLE,
    toasts: toasts
  }, children);
};
exports.AssistantProvider = AssistantProvider;