"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantOverlay = void 0;
var _react = _interopRequireDefault(require("react"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _reactQuery = require("@tanstack/react-query");
var _use_experimental_features = require("../common/hooks/use_experimental_features");
var _kibana = require("../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssistantOverlay = () => {
  const {
    services
  } = (0, _kibana.useKibana)();
  const {
    data: currentUserAvatar
  } = (0, _reactQuery.useQuery)({
    queryKey: ['currentUserAvatar'],
    queryFn: () => {
      var _services$security;
      return (_services$security = services.security) === null || _services$security === void 0 ? void 0 : _services$security.userProfiles.getCurrent({
        dataPath: 'avatar'
      });
    },
    select: data => {
      return data.data.avatar;
    },
    keepPreviousData: true,
    refetchOnWindowFocus: false
  });
  const {
    assistantAvailability
  } = (0, _elasticAssistant.useAssistantContext)();
  const aiAssistantFlyoutMode = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('aiAssistantFlyoutMode');
  if (!assistantAvailability.hasAssistantPrivilege) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_elasticAssistant.AssistantOverlay, {
    isFlyoutMode: aiAssistantFlyoutMode,
    currentUserAvatar: currentUserAvatar
  });
};
exports.AssistantOverlay = AssistantOverlay;